/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.j48.J48Classifier;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.mcfsEngine.framework.GlobalStats;
import dmLab.mcfs.mcfsEngine.modules.Projection;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.statList.StatsList;
import java.util.Random;

public final class MCFSJob
implements Runnable {
    private int jobId;
    private Classifier classifier;
    private Projection projection;
    private ConfusionMatrix localMatrix;
    private MCFSParams mcfsParams;
    private FArray inputArray;
    private AttributesRI[] localImportance;
    private AttributesID localAttrID;
    private StatsList localSplitsStats;
    private GlobalStats globalStats;

    /*
     * WARNING - void declaration
     */
    public MCFSJob(int id, MCFSParams mcfsParams, FArray inputArray, GlobalStats globalStats) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.jobId = var1_1;
        this.globalStats = globalStats;
        this.mcfsParams = mcfsParams;
        this.inputArray = inputArray;
        this.localSplitsStats = new StatsList();
        this.localImportance = GlobalStats.initImportances(mcfsParams, (FArray)var3_3);
        if (var2_2.buildID) {
            this.localAttrID = new AttributesID(globalStats.attrNames, true, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean init(Random random) {
        void var1_1;
        boolean bl;
        boolean bl2;
        MCFSJob mCFSJob;
        block7: {
            mCFSJob = this;
            int[] nArray = new int[]{Classifier.AUTO, Classifier.J48, Classifier.M5, Classifier.ADX, Classifier.SLIQ};
            int n = mCFSJob.mcfsParams.model;
            int n2 = 0;
            while (n2 < 5) {
                if (n == nArray[n2]) {
                    bl2 = true;
                    break block7;
                }
                ++n2;
            }
            bl2 = false;
        }
        if (!bl2) {
            System.err.println("@@@ Thread: " + mCFSJob.jobId + " Error. Unknown defined classifier.");
            bl = false;
        } else {
            mCFSJob.classifier = Classifier.getClassifier(mCFSJob.mcfsParams.model);
            if (!mCFSJob.classifier.params.load(mCFSJob.mcfsParams.classifierCfgPATH, mCFSJob.classifier.label)) {
                bl = false;
            } else {
                mCFSJob.classifier.init();
                mCFSJob.classifier.setTempPath(mCFSJob.mcfsParams.resFilesPATH);
                mCFSJob.classifier.setId(mCFSJob.jobId);
                if (mCFSJob.classifier instanceof J48Classifier) {
                    ((J48Classifier)mCFSJob.classifier).mode = mCFSJob.mcfsParams.wekaClassifierMode;
                }
                bl = mCFSJob.classifier.params.check(mCFSJob.inputArray);
            }
        }
        this.projection = new Projection(this.mcfsParams, (Random)var1_1);
        this.localMatrix = this.inputArray.isTargetNominal() ? new ConfusionMatrix(this.inputArray.getColNames(true)[this.inputArray.getDecAttrIdx()], this.inputArray.getDecValuesStr()) : null;
        return true;
    }

    public final boolean finish() {
        this.classifier.finish();
        return true;
    }

    @Override
    public final void run() {
        boolean keepLoop = true;
        int loopIndex = 0;
        while (keepLoop) {
            ConfusionMatrix matrix = this.projection.projectionLoop(this.classifier, this.inputArray, this.localImportance, this.localAttrID);
            if (this.localMatrix != null) {
                this.localMatrix.add(matrix);
            }
            this.localSplitsStats.add(this.projection.getSplitsStats());
            if (loopIndex % this.mcfsParams.progressInterval == 0 && loopIndex != 0) {
                keepLoop = this.globalStats.update(this.jobId, this.localMatrix, this.localImportance, this.localAttrID);
                int i = 0;
                while (i < this.localImportance.length) {
                    if (this.localImportance[i] != null) {
                        this.localImportance[i].initImportances();
                    }
                    ++i;
                }
                if (this.localMatrix != null) {
                    this.localMatrix.cleanMatrix();
                }
                if (this.localAttrID != null) {
                    this.localAttrID.init();
                }
            }
            ++loopIndex;
        }
        this.globalStats.updateSplitsStats(this.localSplitsStats);
    }
}

