/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.saver.Array2File;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.utils.cmatrix.ConfusionMatrix;
import java.io.File;
import weka.core.Instances;
import weka.core.converters.ArffLoader;

public abstract class WekaClassifier
extends Classifier {
    public int mode = 0;
    protected ArffLoader arffLoader;
    protected Array2File array2File;
    private Instances wekaTrainInstances;
    protected weka.classifiers.Classifier wekaClassifier;

    protected abstract void setParams();

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean train(FArray trainArray) {
        void var1_1;
        if (this.mode == 0) {
            return this.train_memory(trainArray);
        }
        return this.train_file((FArray)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var1_1;
        if (this.mode == 0) {
            FArray fArray = testArray;
            testArray = this;
            double d = System.currentTimeMillis();
            ((WekaClassifier)testArray).setParams();
            int n = fArray.rowsNumber();
            ((WekaClassifier)testArray).predictions = new Prediction[n];
            Instances instances = DiscFunctions.convert(fArray);
            instances.setClassIndex(fArray.getDecAttrIdx());
            ((WekaClassifier)testArray).confusionMatrix = new ConfusionMatrix(fArray.getColNames(true)[fArray.getDecAttrIdx()], fArray.getDecValuesStr());
            super.classifyInstances(instances);
            double d2 = System.currentTimeMillis();
            ((WekaClassifier)testArray).testingTime = (float)((d2 - d) / 1000.0);
            return true;
        }
        return this.test_file((FArray)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean train_memory(FArray trainArray) {
        void var2_3;
        this.setParams();
        double start = System.currentTimeMillis();
        this.trainSetSize = trainArray.rowsNumber();
        this.wekaTrainInstances = DiscFunctions.convert(trainArray);
        this.wekaTrainInstances.setClassIndex(trainArray.getDecAttrIdx());
        try {
            this.wekaClassifier.buildClassifier(this.wekaTrainInstances);
        }
        catch (Exception e) {
            void var1_2;
            System.err.println(String.valueOf(this.getMyName()) + " Error: Training Classifier!");
            var1_2.printStackTrace();
            return false;
        }
        double stop = System.currentTimeMillis();
        this.learningTime = (float)((stop - var2_3) / 1000.0);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean train_file(FArray trainArray) {
        void var2_4;
        this.setParams();
        double start = System.currentTimeMillis();
        String trainFilePath = this.getTmpFilePath("tmp_train.arff");
        this.array2File.saveFile(trainArray, trainFilePath);
        this.trainSetSize = trainArray.rowsNumber();
        File trainFile = new File(trainFilePath);
        try {
            this.arffLoader.setFile(trainFile);
            this.wekaTrainInstances = this.arffLoader.getDataSet();
            this.arffLoader.reset();
            this.wekaTrainInstances.setClassIndex(trainArray.getDecAttrIdx());
            trainFile.delete();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(this.getMyName()) + " Error: Loading Arff files!");
            e.printStackTrace();
            return false;
        }
        try {
            this.wekaClassifier.buildClassifier(this.wekaTrainInstances);
        }
        catch (Exception e) {
            void var1_3;
            System.err.println(String.valueOf(this.getMyName()) + " Error: Training Classifier!");
            var1_3.printStackTrace();
            return false;
        }
        double stop = System.currentTimeMillis();
        this.learningTime = (float)((stop - var2_4) / 1000.0);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean test_file(FArray testArray) {
        void var2_3;
        void var1_1;
        Instances wekaTestInstances;
        double start = System.currentTimeMillis();
        this.setParams();
        String testFilePath = this.getTmpFilePath("tmp_test.arff");
        this.array2File.saveFile(testArray, testFilePath);
        int testSetSize = testArray.rowsNumber();
        this.predictions = new Prediction[testSetSize];
        File testFile = new File(testFilePath);
        try {
            this.arffLoader.setFile(testFile);
            wekaTestInstances = this.arffLoader.getDataSet();
            this.arffLoader.reset();
            wekaTestInstances.setClassIndex(testArray.getDecAttrIdx());
            testFile.delete();
        }
        catch (Exception e) {
            void var1_2;
            System.err.println(String.valueOf(this.getMyName()) + " Error: Loading Arff files!");
            var1_2.printStackTrace();
            return false;
        }
        this.confusionMatrix = new ConfusionMatrix(var1_1.getColNames(true)[var1_1.getDecAttrIdx()], var1_1.getDecValuesStr());
        this.classifyInstances(wekaTestInstances);
        double stop = System.currentTimeMillis();
        this.testingTime = (float)((stop - var2_3) / 1000.0);
        return true;
    }

    private boolean classifyInstances(Instances instances) {
        int size = instances.numInstances();
        int k = 0;
        while (k < size) {
            try {
                String className = instances.instance(k).stringValue(instances.classIndex());
                double predictedClassIndex = this.wekaClassifier.classifyInstance(instances.instance(k));
                String predictedClassName = this.wekaTrainInstances.classAttribute().value((int)predictedClassIndex);
                this.predictions[k] = new Prediction(predictedClassName, null);
                this.confusionMatrix.add(className, predictedClassName);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                System.err.println(String.valueOf(this.getMyName()) + " Instance classification Error!");
                System.err.println("\tInstance: " + instances.instance(k).toString());
            }
            ++k;
        }
        return true;
    }

    private boolean resetARFFLoader() {
        try {
            this.arffLoader.setFile(null);
            this.arffLoader.reset();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public final String toString(boolean header) {
        return this.wekaClassifier.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(" ### " + this.label + " Classifier ### " + this.getMyName() + " ### ").append('\n');
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.wekaClassifier.toString());
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getTmpFilePath(String fileName) {
        void var1_1;
        return String.valueOf(this.tmpPath) + "C" + this.classifierID + "_" + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean finish() {
        void var1_2;
        void var2_3;
        void var3_4;
        this.resetARFFLoader();
        String trainFilePath = this.getTmpFilePath("tmp_train.arff");
        String testFilePath = this.getTmpFilePath("tmp_test.arff");
        File trainFile = new File(trainFilePath);
        File testFile = new File(testFilePath);
        boolean deleted = trainFile.delete() && testFile.delete();
        var3_4.deleteOnExit();
        var2_3.deleteOnExit();
        return (boolean)var1_2;
    }
}

