/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.framework;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.adx.ADXClassifier;
import dmLab.classifier.j48.J48Classifier;
import dmLab.classifier.sliq.SliqClassifier;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.mcfsEngine.framework.GlobalStats;
import dmLab.mcfs.mcfsEngine.modules.Projection;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.statList.StatsList;
import java.util.Random;

public final class MCFSJob
implements Runnable {
    private int jobId;
    private Classifier classifier;
    private Projection projection;
    private ConfusionMatrix localMatrix;
    private MCFSParams mcfsParams;
    private FArray inputArray;
    private AttributesRI[] localImportance;
    private AttributesID localAttrID;
    private StatsList localSplitsStats;
    private GlobalStats globalStats;

    /*
     * WARNING - void declaration
     */
    public MCFSJob(int id, MCFSParams mcfsParams, FArray inputArray, GlobalStats globalStats) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.jobId = var1_1;
        this.globalStats = globalStats;
        this.mcfsParams = mcfsParams;
        this.inputArray = inputArray;
        this.localSplitsStats = new StatsList();
        this.localImportance = GlobalStats.initImportances(mcfsParams, (FArray)var3_3);
        if (var2_2.buildID) {
            this.localAttrID = new AttributesID(globalStats.attrNames, true, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final boolean init(Random random) {
        block6: {
            block5: {
                var2_2 = this;
                if (var2_2.mcfsParams.classifier != Classifier.J48) break block5;
                var2_2.classifier = new J48Classifier();
                ** GOTO lbl15
            }
            if (var2_2.mcfsParams.classifier != Classifier.ADX) break block6;
            var2_2.classifier = new ADXClassifier();
            ** GOTO lbl15
        }
        if (var2_2.mcfsParams.classifier != Classifier.SLIQ) {
            System.err.println("@@@ Thread: " + var2_2.jobId + " Error. Unknown defined classifier.");
            v0 = false;
        } else {
            var2_2.classifier = new SliqClassifier();
lbl15:
            // 3 sources

            if (!var2_2.classifier.params.load(var2_2.mcfsParams.classifierCfgPATH, var2_2.classifier.label)) {
                v0 = false;
            } else {
                var2_2.classifier.init();
                var2_2.classifier.setTempPath(var2_2.mcfsParams.resFilesPATH);
                var2_2.classifier.setClassifierId(var2_2.jobId);
                if (var2_2.classifier instanceof J48Classifier) {
                    ((J48Classifier)var2_2.classifier).mode = var2_2.mcfsParams.wekaClassifierMode;
                }
                v0 = var2_2.classifier.params.check(var2_2.inputArray) != false;
            }
        }
        this.projection = new Projection(this.mcfsParams, (Random)var1_1);
        this.localMatrix = new ConfusionMatrix(this.inputArray.getColNames(true)[this.inputArray.getDecAttrIdx()], this.inputArray.getDecValuesStr());
        return true;
    }

    public final boolean finish() {
        this.classifier.finish();
        return true;
    }

    @Override
    public final void run() {
        boolean keepLoop = true;
        int loopIndex = 0;
        while (keepLoop) {
            ConfusionMatrix matrix = this.projection.projectionLoop(this.classifier, this.inputArray, this.localImportance, this.localAttrID);
            this.localMatrix.add(matrix);
            this.localSplitsStats.add(this.projection.getSplitsStats());
            if (loopIndex % this.mcfsParams.progressInterval == 0 && loopIndex != 0) {
                keepLoop = this.globalStats.update(this.jobId, this.localMatrix, this.localImportance, this.localAttrID);
                int i = 0;
                while (i < this.localImportance.length) {
                    if (this.localImportance[i] != null) {
                        this.localImportance[i].initImportances();
                    }
                    ++i;
                }
                this.localMatrix.cleanMatrix();
                if (this.localAttrID != null) {
                    this.localAttrID.init();
                }
            }
            ++loopIndex;
        }
        this.globalStats.updateSplitsStats(this.localSplitsStats);
    }
}

