/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.cmatrix.AccuracyMeasure;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.dataframe.DataFrame;
import java.util.Random;

public final class MCFSFinalCV {
    private int[] algorithms;
    private Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSFinalCV(int[] algorithms, Random random) {
        void var2_2;
        void var1_1;
        this.algorithms = var1_1;
        this.random = var2_2;
    }

    public final DataFrame run(FArray array, AttributesRI importances, int[] size, int cvFolds, int setSize, int repetitions) {
        DiscFunctions selectFunctions = new DiscFunctions(this.random);
        if (array.rowsNumber() <= setSize) {
            repetitions = 1;
        }
        DataFrame result_df = null;
        int i = 0;
        while (i < size.length) {
            int currSize = size[i];
            if (currSize > 0) {
                FArray fArray = array;
                if (currSize < fArray.attributes.length - 1) {
                    FArray topRankingArray;
                    fArray = topRankingArray = (FArray)DiscFunctions.selectColumns(array, importances, currSize);
                    System.out.println("*** Running CV experiment on top " + fArray.attributes.length + " attributes and " + topRankingArray.rowsNumber() + " rows ***");
                    DataFrame step_df = null;
                    int j = 0;
                    while (j < repetitions) {
                        FArray rep_array = (FArray)selectFunctions.selectRowsRandom(topRankingArray, setSize);
                        if (repetitions > 1) {
                            fArray = rep_array;
                            System.out.println("*** CV Repetition = " + (j + 1) + ". Array size: rows=" + rep_array.rowsNumber() + " cols=" + fArray.attributes.length);
                        }
                        DataFrame rep_df = this.singleCV(rep_array, Integer.toString(currSize), cvFolds);
                        if (step_df == null) {
                            step_df = rep_df;
                        } else {
                            step_df.mathOperation(rep_df, "+");
                        }
                        ++j;
                    }
                    step_df.mathOperation(repetitions, "/");
                    if (result_df == null) {
                        result_df = step_df;
                    } else {
                        result_df.rbind(step_df);
                    }
                }
            }
            ++i;
        }
        return result_df;
    }

    private DataFrame singleCV(FArray array, String label, int cvFolds) {
        DataFrame df = new DataFrame(this.algorithms.length, 4);
        df.setColNames(new String[]{"label", "algorithm", "acc", "wacc"});
        short[] sArray = new short[4];
        sArray[2] = 1;
        sArray[3] = 1;
        df.setColTypes(sArray);
        ClassificationBody classification = new ClassificationBody(this.random);
        classification.setParameters(new ClassificationParams());
        classification.classParams.debug = false;
        classification.classParams.verbose = false;
        classification.classParams.saveClassifier = false;
        classification.classParams.savePredictionResult = false;
        classification.classParams.classifierCfgPATH = "";
        classification.classParams.folds = cvFolds;
        int i = 0;
        while (i < this.algorithms.length) {
            classification.classParams.classifier = this.algorithms[i];
            classification.createClassifier();
            System.out.println("Running CV " + cvFolds + " fold. Algorithm: " + Classifier.int2label(this.algorithms[i]));
            ConfusionMatrix matrix = classification.singleCV(array, "");
            df.set(i, 0, label);
            df.set(i, 1, Classifier.int2label(this.algorithms[i]));
            df.set(i, 2, Float.valueOf(matrix.calcMeasure(AccuracyMeasure.ACC)));
            df.set(i, 3, Float.valueOf(matrix.calcMeasure(AccuracyMeasure.WACC)));
            ++i;
        }
        return df;
    }
}

