% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{sc_Symm}
\alias{sc_Symm}
\title{Simulating Count Data From The Output of Real Data Analysis (corSymm)}
\usage{
sc_Symm(BetaMat, Sigma2Vec, RhoVec, WeightMat, lib.size, design, Subject,
  Time, nrep)
}
\arguments{
\item{BetaMat}{a matrix of estimates of regression coefficients.}

\item{Sigma2Vec}{a vector of shrinkage estimates of error variances.}

\item{RhoVec}{a vector of estimates of correlation.}

\item{WeightMat}{a matrix of weights of all genes obtaining from voom.}

\item{lib.size}{library size in voom method, we choose .75 quantile as library
size.}

\item{design}{a design matrix.}

\item{Subject}{a vector of subjects/experimental units.}

\item{Time}{a vector of time points.}

\item{nrep}{simulation iteration.}
}
\value{
a matrix of count data that has nrow(BetaMat) rows and nrow(design)
 columns.
}
\description{
This function generates bootstrap samples using parametric bootstrap method.
}
\examples{
\donttest{
data(resSymm)
v <- resSymm$ori.res$v[1:20,]
newlm <- resSymm$ori.res$newlm[1:20,]
BetaMat <- data.matrix(newlm[grep("fixed.", names(newlm))])
Sigma2Vec <- newlm$s2_shrunken
RhoVec <- data.matrix(newlm[grep("rho.", names(newlm))])
WeightMat <- v$weights
lib.size <- v$targets$lib.size
nrep <- 1
Subject <- covset$ear
Time <- covset$time
simcounts <- rmRNAseq:::sc_Symm(BetaMat, Sigma2Vec, RhoVec, WeightMat,
lib.size, design, Subject, Time,nrep)
dim(simcounts)
}
}
