% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listing_export.R
\name{export_as_txt}
\alias{export_as_txt}
\title{Export as plain text with page break symbol}
\usage{
export_as_txt(
  lst,
  file = NULL,
  page_type = NULL,
  landscape = FALSE,
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  font_family = "Courier",
  font_size = 8,
  paginate = .need_pag(page_type, pg_width, pg_height, lpp, cpp),
  cpp = NULL,
  lpp = NULL,
  ...,
  page_break = "\\\\s\\\\n",
  hsep = default_hsep(),
  indent_size = 2,
  tf_wrap = paginate,
  max_width = cpp,
  colwidths = propose_column_widths(matrix_form(lst, TRUE))
)
}
\arguments{
\item{lst}{Listing object}

\item{file}{character(1). File to write.}

\item{page_type}{character(1).   Name   of  a  page  type.   See
\code{page_types}.   Ignored when  \code{pg_width} and  \code{pg_height}
are set directly.}

\item{landscape}{logical(1). Should the  dimensions of \code{page_type}
be inverted  for landscape?  Defaults to  \code{FALSE}, ignored when
\code{pg_width} and \code{pg_height} are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{font_size}{numeric(1). Font size, defaults to 8.}

\item{paginate}{logical(1). Should \code{lst} be paginated before writing the file.
Defaults to \code{TRUE} if any sort of page dimension is specified.}

\item{cpp}{numeric(1) or NULL. Width (in characters) of the pages for
horizontal pagination. \code{NULL} (the default) indicates no horizontal
pagination should be done.}

\item{lpp}{numeric(1) or NULL. Number of row lines (not counting titles and
footers) to have per page. Standard is \code{70} while \code{NULL} disables vertical
pagination.}

\item{\dots}{Passed directly to \code{\link{paginate_listing}}}

\item{page_break}{character(1). Page break symbol (defaults to outputting \code{"\\s"}).}

\item{hsep}{character(1).   Characters  to  repeat   to  create
header/body separator line.}

\item{indent_size}{numeric(1). Indent size in characters. Ignored
when \code{x} is already a MatrixPrintForm object in favor of information
there.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}

\item{colwidths}{numeric vector.  Column widths (in characters) for
use with vertical pagination.}
}
\value{
\code{file} (this function is called for the side effect of writing the file.
}
\description{
Export as plain text with page break symbol
}
\note{
When specified, \code{font_size} is used \emph{only} to determine pagination based
on page dimensions. The written file is populated in raw ASCII text, which
does not have the concept of font size.
}
\examples{

dat <- ex_adae
lsting <- as_listing(dat[1:25, ], key_cols = c("USUBJID", "AESOC")) \%>\%
  add_listing_col("AETOXGR") \%>\%
  add_listing_col("BMRKR1", format = "xx.x") \%>\%
  add_listing_col("AESER / AREL", fun = function(df) paste(df$AESER, df$AREL, sep = " / "))
main_title(lsting) <- "this is some title"
main_footer(lsting) <- "this is some footer"
cat(export_as_txt(lsting, file = NULL, paginate = TRUE))

}
