% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotEnhancedVolcano}
\alias{plotEnhancedVolcano}
\title{Create volcano plot with EnhancedVolcano}
\usage{
plotEnhancedVolcano(result, group, ...)
}
\arguments{
\item{result}{Data frame table returned by \code{\link{runMarkerDEG}} or
\code{\link{runPairwiseDEG}}.}

\item{group}{Selection of one group available from \code{result$group}. If
only one group is available from \code{result}, default \code{NULL} uses it.}

\item{...}{Arguments passed to EnhancedVolcano::EnhancedVolcano(), except
that \code{toptable}, \code{lab}, \code{x} and \code{y} are prefilled by this
wrapper.}
}
\value{
ggplot
}
\description{
Create volcano plot with EnhancedVolcano
}
\examples{
\donttest{
if (requireNamespace("EnhancedVolcano", quietly = TRUE)) {
    defaultCluster(pbmc) <- pbmcPlot$leiden_cluster
    # Test the DEG between "stim" and "ctrl", within each cluster
    result <- runPairwiseDEG(
        pbmc,
        groupTest = "stim",
        groupCtrl = "ctrl",
        variable1 = "dataset",
        splitBy = "defaultCluster"
    )
    plotEnhancedVolcano(result, "0.stim")
}
}
}
