% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{reorganizeLiger}
\alias{reorganizeLiger}
\title{Construct a liger object organized by another feature}
\usage{
reorganizeLiger(
  object,
  by.feature,
  keep.meta = TRUE,
  new.label = "orig.dataset",
  ...
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{by.feature}{Column in cell.data to use in reorganizing raw data.}

\item{keep.meta}{Whether to carry over all existing data in cell.data slot (default TRUE).}

\item{new.label}{If cell.data is to be retained, new column name for original organizing feature
(previously labeled as dataset) (default "orig.dataset")}

\item{...}{Additional parameters passed on to createLiger.}
}
\value{
\code{liger} object with rearranged raw.data slot.
}
\description{
Using the same data, rearrange functional datasets using another discrete feature in cell.data.
This removes most computed data slots, though cell.data and current clustering can be retained.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
# Create a random variable of two categories
ligerex@cell.data$foo <- factor(sample(c(1,2), 600, replace = TRUE))
ligerexFoo <- reorganizeLiger(ligerex, "foo")
}
