% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{seuratToLiger}
\alias{seuratToLiger}
\title{Create liger object from one or more Seurat objects}
\usage{
seuratToLiger(
  objects,
  combined.seurat = FALSE,
  names = "use-projects",
  meta.var = NULL,
  assays.use = NULL,
  raw.assay = "RNA",
  remove.missing = TRUE,
  renormalize = TRUE,
  use.seurat.genes = TRUE,
  num.hvg.info = NULL,
  use.idents = TRUE,
  use.tsne = TRUE,
  cca.to.H = FALSE
)
}
\arguments{
\item{objects}{One or more Seurat v2 objects. If passing multiple objects, should be in list.}

\item{combined.seurat}{Whether Seurat object (single) already contains multiple datasets (default
FALSE).}

\item{names}{Names to use for datasets in new liger object. If use-projects, takes project names
from individual Seurat objects; if use-meta, takes value of object meta.data in meta.var column
for each dataset; otherwise, user can pass in vector of names with same length
as number of datasets. If combined.seurat, infers project names based on whether meta.var
or assays.use is present (at least one required).}

\item{meta.var}{Seurat meta.data column name to use in naming datasets. Either meta.var or
assays.use required if combined.seurat is TRUE (default NULL).}

\item{assays.use}{Names of Seurat v3 assays to use as separate datasets in conversion (e.g. RNA,
ADT) (default NULL).}

\item{raw.assay}{Name of Seurat v3 assay to use for raw data if meta.var used to split combined
Seurat object -- in case integrated assay has been set as default (default "RNA").}

\item{remove.missing}{Whether to remove missing genes/cells when converting raw.data to liger object
(default TRUE).}

\item{renormalize}{Whether to automatically normalize raw.data once \code{liger} object is created
(default TRUE).}

\item{use.seurat.genes}{Carry over variable genes from Seurat objects. If num.hvg.info is set, uses
that value to get top most highly variable genes from hvg.info slot in Seurat objects. Otherwise
uses var.genes slot in Seurat objects. For multiple datasets, takes the union of the variable
genes. (default TRUE)}

\item{num.hvg.info}{Number of highly variable genes to include from each object's hvg.info slot.
Only available for Seurat v2 objects. If set, recommended value is 2000 (default NULL).}

\item{use.idents}{Carry over cluster identities from Seurat objects. If multiple objects with
overlapping cluster names, will preface cluster names by dataset names to distinguish. (default
TRUE).}

\item{use.tsne}{Carry over t-SNE coordinates from Seurat object (only meaningful for combined
analysis Seurat object). Useful for plotting directly afterwards. (default TRUE)}

\item{cca.to.H}{Carry over CCA (and aligned) loadings and insert them into H (and H.norm) slot in
liger object (only meaningful for combined analysis Seurat object). Useful for plotting directly
afterwards. (default FALSE)}
}
\value{
\code{liger} object.
}
\description{
This function creates a \code{liger} object from multiple (disjoint) Seurat objects or a single
(combined-analysis) Seurat object. It includes options for keeping the variable genes and cluster
identities from the original Seurat objects. Seurat V2 and V3 supported (though all objects
should share the same major version).
}
\examples{
\dontrun{
# Seurat objects for two pbmc datasets
tenx <- readRDS('tenx.RDS')
seqwell <- readRDS('seqwell.RDS')
# create liger object, using project names
ligerex <- seuratToLiger(list(tenx, seqwell))
# create liger object, passing in names explicitly, using hvg.info genes
ligerex2 <- seuratToLiger(list(tenx, seqwell), names = c('tenx', 'seqwell'), num.hvg.info = 2000)
# Seurat object for joint analysis
pbmc <- readRDS('pbmc.RDS')
# create liger object, using 'protocol' for dataset names
ligerex3 <- seuratToLiger(pbmc, combined.seurat = TRUE, meta.var = 'protocol', num.hvg.info = 2000)
}
}
