% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{phi}
\alias{phi}
\title{Phi}
\usage{
phi(t, k, path, H, freq)
}
\arguments{
\item{t}{positive real number}

\item{k}{increment order}

\item{path}{sample path of lfsm on which the inference is to be performed}

\item{H}{Hurst parameter}

\item{freq}{Frequency of the motion. It can take two values: "H" for high frequency and "L" for the low frequency setting.}
}
\description{
Defined as
\deqn{\varphi_{\textnormal{high}}(t; H,k)_n := V_{\textnormal{high}}(\psi_t; k)_n \qquad \textnormal{and}
\qquad \varphi_{\textnormal{low}}(t; k)_n := V_{\textnormal{low}}(\psi_t; k)_n},
where \eqn{\psi_t(x):=cos(tx)}
}
\details{
Hurst parameter is required only in high frequency case. In the low frequency, there is no need to assign H a value because it will not be evaluated.
}
\references{
\insertRef{MOP18}{rlfsm}
}
