% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_h_kr.R
\name{h_kr}
\alias{h_kr}
\title{Function h_kr}
\usage{
h_kr(k, r, x, H, alpha, l = 0)
}
\arguments{
\item{k}{order of the increment, a natural number}

\item{r}{difference step, a natural number}

\item{x}{real number}

\item{H}{Hurst parameter}

\item{alpha}{self-similarity parameter of alpha stable random motion.}

\item{l}{a value by which we shift x. Is used for computing function f_.+l and is passed to integrate function.}
}
\description{
Function \eqn{h_{k,r}: R \to R} is given by \deqn{h_{k,r} (x) = \sum_{j=0}^k (-1)^j {{k}\choose{j}} (x-rj)_+^{H-1/\alpha}, \ \ \ x\in R}
}
\examples{
#### Plot h_kr ####
s<-seq(0,10, by=0.01)
h_val<-sapply(s,h_kr, k=5, r=1, H=0.3, alpha=1)
plot(s,h_val)
}
\references{
\insertRef{MOP18}{rlfsm}
}
