/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging,
ScalaObject {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String TopicConfigPath;
    private final String TopicConfigChangesPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ String createSequentialPersistentPath$default$3() {
        return "";
    }

    public /* synthetic */ String createPersistentPath$default$3() {
        return "";
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String TopicConfigPath() {
        return this.TopicConfigPath;
    }

    public String TopicConfigChangesPath() {
        return this.TopicConfigChangesPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicConfigPath(String topic) {
        return new StringBuilder().append((Object)this.TopicConfigPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public int getController(ZkClient zkClient) {
        Option<String> option = this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            return KafkaController$.MODULE$.parseControllerId((String)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError(option);
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append(BoxesRunTime.boxToInteger(partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Integer> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map(new anonfun.getSortedBrokerList.1(), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient$4) {
        Seq brokerIds = (Seq)this.getChildrenParentMayNotExist(zkClient$4, this.BrokerIdsPath()).sorted(Ordering$String$.MODULE$);
        return ((TraversableLike)((TraversableLike)((TraversableLike)brokerIds.map(new anonfun.getAllBrokersInCluster.1(), Seq$.MODULE$.canBuildFrom())).map(new anonfun.getAllBrokersInCluster.2(zkClient$4), Seq$.MODULE$.canBuildFrom())).filter(new anonfun.getAllBrokersInCluster.3())).map(new anonfun.getAllBrokersInCluster.4(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    String leaderAndIsrPath = this.getTopicPartitionLeaderAndIsrPath(topic, partition2);
                    Tuple2<Option<String>, Stat> leaderAndIsrInfo = this.readDataMaybeNull(zkClient, leaderAndIsrPath);
                    Option<String> leaderAndIsrOpt = leaderAndIsrInfo._1();
                    Stat stat = leaderAndIsrInfo._2();
                    option = leaderAndIsrOpt;
                    if (!(option instanceof Some)) break block2;
                    none$ = this.parseLeaderAndIsr((String)((Some)option).x(), topic, partition2, stat);
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<String> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String topic, int partition2) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, topic, partition2).map(new anonfun.getLeaderAndIsrForPartition.1());
    }

    public void setupCommonPaths(ZkClient zkClient$8) {
        ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerIdsPath(), this.BrokerTopicsPath(), this.TopicConfigChangesPath(), this.TopicConfigPath(), this.DeleteTopicsPath()}))).foreach(new anonfun.setupCommonPaths.1(zkClient$8));
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String topic$1, int partition$1, Stat stat) {
        Option<Object> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    Object a;
                    option = Json$.MODULE$.parseFull(leaderAndIsrStr);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object m = a = some.x();
                    Map leaderIsrAndEpochInfo = (Map)m;
                    int leader$1 = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("leader").get());
                    int epoch$1 = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("leader_epoch").get());
                    List isr$1 = (List)leaderIsrAndEpochInfo.get("isr").get();
                    int controllerEpoch = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("controller_epoch").get());
                    int zkPathVersion$1 = stat.getVersion();
                    this.debug((Function0<String>)new anonfun.parseLeaderAndIsr.1(topic$1, partition$1, leader$1, epoch$1, isr$1, zkPathVersion$1));
                    option2 = new Some<LeaderIsrAndControllerEpoch>(new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader$1, epoch$1, isr$1, zkPathVersion$1), controllerEpoch));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Option<Integer> getLeaderForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block6: {
            Option option2;
            block4: {
                block2: {
                    Option<Object> option3;
                    block5: {
                        block3: {
                            Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String leaderAndIsr = string2;
                            option3 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option3 instanceof Some)) break block3;
                            option2 = new Some<Integer>(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(((Map)((Some)option3).x()).get("leader").get())));
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option4 = option3;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                        option2 = None$.MODULE$;
                        break block4;
                    }
                    throw new MatchError(option3);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option5 = option;
                if (none$ != null ? !none$.equals(option5) : option5 != null) break block6;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getEpochForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
        Option<String> option = leaderAndIsrOpt;
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            String leaderAndIsr = string2 = (String)some.x();
            Option<Object> option2 = Json$.MODULE$.parseFull(leaderAndIsr);
            None$ none$ = None$.MODULE$;
            Option<Object> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
            }
            if (option2 instanceof Some) {
                return BoxesRunTime.unboxToInt(((Map)((Some)option2).x()).get("leader_epoch").get());
            }
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        }
        throw new MatchError(option);
    }

    public Seq<Integer> getInSyncReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block6: {
            Seq seq2;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String leaderAndIsr = string2;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            seq2 = (Seq)((Map)((Some)option2).x()).get("isr").get();
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        seq2 = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                seq2 = (Seq)Seq$.MODULE$.empty();
            }
            return seq2;
        }
        throw new MatchError(option);
    }

    public Seq<Integer> getReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block10: {
            Seq seq2;
            block6: {
                block2: {
                    Option<Object> option2;
                    block9: {
                        block3: {
                            Option option3;
                            block8: {
                                block4: {
                                    Option option4;
                                    block7: {
                                        block5: {
                                            Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.getTopicPath(topic))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string2 = (String)some.x();
                                            String jsonPartitionMap = string2;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object a = some2.x();
                                            Object m = a;
                                            option3 = ((Map)m).get("partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object a2 = some3.x();
                                            Object replicaMap = a2;
                                            option4 = ((Map)replicaMap).get(((Object)BoxesRunTime.boxToInteger(partition2)).toString());
                                            if (!(option4 instanceof Some)) break block5;
                                            seq2 = (Seq)((Some)option4).x();
                                            break block6;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option5 = option4;
                                        if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                        seq2 = (Seq)Seq$.MODULE$.empty();
                                        break block6;
                                    }
                                    throw new MatchError(option4);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option6 = option3;
                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                seq2 = (Seq)Seq$.MODULE$.empty();
                                break block6;
                            }
                            throw new MatchError(option3);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option7 = option2;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block9;
                        seq2 = (Seq)Seq$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option8 = option;
                if (none$ != null ? !none$.equals(option8) : option8 != null) break block10;
                seq2 = (Seq)Seq$.MODULE$.empty();
            }
            return seq2;
        }
        throw new MatchError(option);
    }

    public void registerBrokerInZk(ZkClient zkClient, int id$1, String host$1, int port$1, int timeout, int jmxPort) {
        String brokerIdPath$1 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(id$1)).toString();
        String timestamp = ((Object)BoxesRunTime.boxToLong(SystemTime$.MODULE$.milliseconds())).toString();
        String brokerInfo = Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("host").$minus$greater(host$1), Predef$.MODULE$.any2ArrowAssoc("port").$minus$greater(BoxesRunTime.boxToInteger(port$1)), Predef$.MODULE$.any2ArrowAssoc("jmx_port").$minus$greater(BoxesRunTime.boxToInteger(jmxPort)), Predef$.MODULE$.any2ArrowAssoc("timestamp").$minus$greater(timestamp)})));
        Broker expectedBroker = new Broker(id$1, host$1, port$1);
        try {
            this.createEphemeralPathExpectConflictHandleZKBug(zkClient, brokerIdPath$1, brokerInfo, expectedBroker, new anonfun.registerBrokerInZk.1(), timeout);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)brokerIdPath$1).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
        this.info((Function0<String>)new anonfun.registerBrokerInZk.2(id$1, host$1, port$1, brokerIdPath$1));
    }

    public String getConsumerPartitionOwnerPath(String group, String topic, int partition2) {
        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topic);
        return new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append(BoxesRunTime.boxToInteger(partition2)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("leader").$minus$greater(BoxesRunTime.boxToInteger(leaderAndIsr.leader())), Predef$.MODULE$.any2ArrowAssoc("leader_epoch").$minus$greater(BoxesRunTime.boxToInteger(leaderAndIsr.leaderEpoch())), Predef$.MODULE$.any2ArrowAssoc("controller_epoch").$minus$greater(BoxesRunTime.boxToInteger(controllerEpoch)), Predef$.MODULE$.any2ArrowAssoc("isr").$minus$greater(leaderAndIsr.isr())})));
    }

    public String replicaAssignmentZkData(Map<String, Seq<Integer>> map2) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("partitions").$minus$greater(map2)})));
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.createEphemeral(path, data2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$4, String data$3) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$4, data$3);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = this.readData(client, path$4)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string2 = (String)storedData$1.elem;
                String string3 = data$3;
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block6;
                this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.2(path$4, data$3));
            }
            return;
        }
        this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.1(path$4, data$3, storedData$1));
        throw zkNodeExistsException2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createEphemeralPathExpectConflictHandleZKBug(ZkClient zkClient, String path$2, String data$2, Object expectedCallerData, Function2<String, Object, Boolean> checker, int backoffTime) {
        this.createEphemeralPathExpectConflict(zkClient, path$2, data$2);
        return;
    }

    public void createPersistentPath(ZkClient client, String path, String data2) {
        try {
            client.createPersistent(path, data2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createPersistent(path, data2);
        }
    }

    public String createSequentialPersistentPath(ZkClient client, String path, String data2) {
        return client.createPersistentSequential(path, data2);
    }

    public void updatePersistentPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, data2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, data2);
            }
        }
    }

    public Tuple2<Boolean, Integer> conditionalUpdatePersistentPath(ZkClient client, String path$1, String data$1, int expectVersion$1) {
        Tuple2<Boolean, Integer> exceptionResult1 = null;
        try {
            Stat stat$1 = client.writeDataReturnStat(path$1, data$1, expectVersion$1);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPath.1(path$1, data$1, expectVersion$1, stat$1));
            exceptionResult1 = new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(stat$1.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPath.2(path$1, data$1, expectVersion$1, exception));
            exceptionResult1 = new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(-1));
        }
        return exceptionResult1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Boolean, Integer> conditionalUpdatePersistentPathIfExists(ZkClient client, String path$5, String data$4, int expectVersion$2) {
        Tuple2<Boolean, Integer> exceptionResult2 = null;
        try {
            Stat stat$2 = client.writeDataReturnStat(path$5, data$4, expectVersion$2);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.1(path$5, data$4, expectVersion$2, stat$2));
            return new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(stat$2.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.2(path$5, data$4, expectVersion$2, exception));
            return new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(-1));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean deletePath(ZkClient client, String path$3) {
        void var3_3;
        boolean exceptionResult3 = false;
        try {
            exceptionResult3 = client.delete(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePath.1(path$3));
            exceptionResult3 = false;
        }
        return (boolean)var3_3;
    }

    public void deletePathRecursive(ZkClient client, String path$6) {
        try {
            client.deleteRecursive(path$6);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePathRecursive.1(path$6));
        }
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String dataStr = (String)client.readData(path, stat);
        return new Tuple2<String, Stat>(dataStr, stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient client, String path) {
        Stat stat = new Stat();
        Tuple2<Option<String>, Stat> exceptionResult4 = null;
        try {
            exceptionResult4 = new Tuple2(new Some(client.readData(path, stat)), stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            exceptionResult4 = new Tuple2<Option<String>, Stat>(None$.MODULE$, stat);
        }
        Tuple2<Option<String>, Stat> dataAndStat = exceptionResult4;
        return dataAndStat;
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        Buffer<String> exceptionResult5 = null;
        try {
            exceptionResult5 = JavaConversions$.MODULE$.asBuffer(client.getChildren(path));
            return exceptionResult5;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$5) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$5, this.BrokerIdsPath());
        nodes.foreach(new anonfun.getCluster.1(zkClient$5, cluster$1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient$7, Set<TopicAndPartition> topicAndPartitions) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topicAndPartitions.foreach(new anonfun.getPartitionLeaderAndIsrForTopics.1(zkClient$7, ret$1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, Seq<Integer>> getReplicaAssignmentForTopics(ZkClient zkClient$1, Seq<String> topics) {
        void var3_3;
        HashMap ret$2 = new HashMap();
        topics.foreach(new anonfun.getReplicaAssignmentForTopics.1(zkClient$1, ret$2));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, Map<Integer, Seq<Integer>>> getPartitionAssignmentForTopics(ZkClient zkClient$2, Seq<String> topics) {
        void var3_3;
        HashMap ret$3 = new HashMap();
        topics.foreach(new anonfun.getPartitionAssignmentForTopics.1(zkClient$2, ret$3));
        return var3_3;
    }

    public scala.collection.mutable.Map<String, Seq<Integer>> getPartitionsForTopics(ZkClient zkClient, Seq<String> topics) {
        return this.getPartitionAssignmentForTopics(zkClient, topics).map(new anonfun.getPartitionsForTopics.1(), Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option<String> option;
        block4: {
            Map map2;
            block3: {
                block2: {
                    String string2;
                    Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = jsonPartitionMapOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionMap = string2 = (String)some.x();
                    Map<TopicAndPartition, Seq<Integer>> reassignedPartitions = this.parsePartitionReassignmentData(jsonPartitionMap);
                    map2 = reassignedPartitions.map(new anonfun.getPartitionsBeingReassigned.1(), scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                map2 = scala.collection.Map$.MODULE$.empty();
            }
            return map2;
        }
        throw new MatchError(option);
    }

    public Map<TopicAndPartition, Seq<Integer>> parsePartitionReassignmentData(String jsonData) {
        Option<Object> option;
        block9: {
            scala.collection.mutable.Map reassignedPartitions$1;
            block8: {
                block7: {
                    reassignedPartitions$1 = (scala.collection.mutable.Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object a = some.x();
                    Object m = a;
                    Option option2 = ((Map)m).get("partitions");
                    if (option2 instanceof Some) {
                        ((Seq)((Some)option2).x()).foreach(new anonfun.parsePartitionReassignmentData.1(reassignedPartitions$1));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError(option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return reassignedPartitions$1;
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block9: {
            ObjectRef topics$1;
            block8: {
                block7: {
                    topics$1 = new ObjectRef(List$.MODULE$.empty());
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object a = some.x();
                    Object m = a;
                    Option option2 = ((Map)m).get("topics");
                    if (option2 instanceof Some) {
                        Object a2;
                        Some some2 = (Some)option2;
                        Object partitionsSeq = a2 = some2.x();
                        Seq mapPartitionSeq = (Seq)partitionsSeq;
                        mapPartitionSeq.foreach(new anonfun.parseTopicsData.1(topics$1));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError(option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return (List)topics$1.elem;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("partitions").$minus$greater(partitionsToBeReassigned.map(new anonfun.getPartitionReassignmentZkData.1(), Iterable$.MODULE$.canBuildFrom()))})));
    }

    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Integer>> partitionsToBeReassigned) {
        String zkPath$1 = this.ReassignPartitionsPath();
        int n = partitionsToBeReassigned.size();
        if (n == 0) {
            this.deletePath(zkClient, zkPath$1);
            this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.1(zkPath$1));
        } else {
            String jsonData$1 = this.getPartitionReassignmentZkData(partitionsToBeReassigned);
            try {
                this.updatePersistentPath(zkClient, zkPath$1, jsonData$1);
                this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.2(jsonData$1));
            }
            catch (Throwable throwable) {
                throw new AdminOperationException(throwable.toString());
            }
            catch (ZkNoNodeException zkNoNodeException) {
                this.createPersistentPath(zkClient, zkPath$1, jsonData$1);
                this.debug((Function0<String>)new anonfun.updatePartitionReassignmentData.3(zkPath$1, jsonData$1));
            }
        }
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option<String> option;
        block4: {
            Traversable<TopicAndPartition> traversable;
            block3: {
                block2: {
                    Option<String> jsonPartitionListOpt = this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = jsonPartitionListOpt;
                    if (!(option instanceof Some)) break block2;
                    traversable = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData((String)((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                traversable = Set$.MODULE$.empty();
            }
            return traversable;
        }
        throw new MatchError(option);
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient$6, String group$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$6, dirs.consumerRegistryDir());
        HashMap<String, List<String>> consumersPerTopicMap$1 = new HashMap<String, List<String>>();
        consumers.foreach(new anonfun.getConsumersPerTopic.1(zkClient$6, group$1, consumersPerTopicMap$1));
        consumersPerTopicMap$1.foreach(new anonfun.getConsumersPerTopic.2(consumersPerTopicMap$1));
        return consumersPerTopicMap$1;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int brokerId) {
        Option<String> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    option = this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    option2 = new Some<Broker>(Broker$.MODULE$.createBroker(brokerId, (String)((Some)option).x()));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? (Seq)Seq$.MODULE$.empty() : topics;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient$3) {
        Seq<String> topics = this.getChildrenParentMayNotExist(zkClient$3, this.BrokerTopicsPath());
        return topics == null ? Set$.MODULE$.empty() : ((GenericTraversableTemplate)topics.map(new anonfun.getAllPartitions.1(zkClient$3), Seq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms()).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.TopicConfigPath = "/config/topics";
        this.TopicConfigChangesPath = "/config/changes";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

