% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graduallyvariedflow_v2.r
\name{compute_profile}
\alias{compute_profile}
\title{Gradually-varied flow profiles}
\usage{
compute_profile(
  So,
  n,
  Q,
  y0,
  Cm,
  g,
  B,
  SS,
  z0 = 0,
  x0 = 0,
  stepdist,
  totaldist
)
}
\arguments{
\item{So}{Channel slope [\eqn{L L^{-1}}].}

\item{n}{Manning's roughness coefficient.}

\item{Q}{Flow rate [\eqn{L^3 T^{-1}}].}

\item{y0}{The water depth at the control section [\eqn{L}].}

\item{Cm}{Unit conversion coefficient for Manning's equation. For SI units, Cm = 1.}

\item{g}{Gravitational acceleration [\eqn{L T^{-2}}].}

\item{B}{Channel bottom width [\eqn{L}].}

\item{SS}{Channel sideslope [\eqn{L L^{-1}}].}

\item{z0}{Elevation reference datum at control section [\eqn{L}]. Default is 0.}

\item{x0}{Distance reference at control section [\eqn{L}]. Default is 0.}

\item{stepdist}{The spatial interval used in the Standard step method [\eqn{L}].}

\item{totaldist}{The total distance upstream (or downstream) to compute the profile [\eqn{L}].}
}
\value{
data.frame with columns:
  \item{x}{Along-channel distance.}
  \item{z}{Elevation.}
  \item{y}{Flow depth.}
  \item{v}{Flow velocity.}
  \item{A}{Flow area.}
  \item{Sf}{Friction slope.}
  \item{E}{Total energy.}
  \item{Fr}{Froude Number.}
}
\description{
Compute the gradually-varied flow profile of a prismatic channel.
}
\details{
Computes the longitudinal water surface profile of a prismatic 
  channel using the standard step method by solving the non-linear ODE 
  \deqn{\frac{dy}{dx} = \frac{S_0 - S_f}{1 - Fr^2}} The standard-step 
  method operates by stepping along the channel by a constant distance 
  interval, starting from a cross-section where the flow depth is known 
  (the control section). The flow depth is computed at the adjacent 
  cross-section (target section). The computed value at the target is then 
  used as the basis for computing flow depth at the next cross-section, i.e. 
  the previous target section becomes the new control section for each step. 
  A Newton-Raphson scheme is used each step to compute the flow depth and 
  friction slope. Technically, the average friction slope of the control and
  target section is used to compute the flow depth at the target section.
}
\examples{
# example M1 profile
compute_profile(0.001, 0.045, 250, 2.7, 1.486, 32.2, 100, 0, stepdist = 10, totaldist = 3000)
# example M2 profile
compute_profile(0.001, 0.045, 250, 0.64, 1.486, 32.2, 100, 0, stepdist = 10, totaldist = 3000)
# example S2 profile
compute_profile(0.005, 0.01, 250, 2.65, 1.486, 32.2, 10, 0, stepdist = 10, totaldist = 2000)
# example S3 profile
compute_profile(0.005, 0.01, 250, 0.5, 1.486, 32.2, 10, 0, stepdist = 10, totaldist = 2000)
}
