% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{critical_depth}
\alias{critical_depth}
\title{Critical depth}
\usage{
critical_depth(Q, yopt, g, B, SS)
}
\arguments{
\item{Q}{Flow rate [\eqn{L^3 T^{-1}}].}

\item{yopt}{Initial guess for normal depth [\eqn{L}].}

\item{g}{Gravitational acceleration [\eqn{L T^{-2}}].}

\item{B}{Channel bottom width [\eqn{L}].}

\item{SS}{Channel sideslope [\eqn{L L^{-1}}].}
}
\value{
The critical depth \eqn{y_c} [\eqn{L}].
}
\description{
Calculate the critical depth.
}
\details{
The critical depth is the water depth at which a channel
  flow regime will transition from supercritical to subcritical (or vice versa).
  Calculation of the critical depth is based on a specific energy formulation,
  i.e. \deqn{E = y + z + \frac{Q^2}{2gB^2y^2}} where \eqn{y} is the flow depth, \eqn{z} is
  the elevation relative to some datum (assumed to be 0), and the last term
  represents kinetic energy. More specifically, the function operates
  by finding the point where the derivative of specific energy w.r.t. \eqn{y} is zero, i.e.
  \eqn{y = y_c} when \deqn{\frac{dE}{dy} = 1 - \frac{Q^2}{gA^3}\frac{dA}{dy} = 0}.
}
\examples{
critical_depth(250, 2, 32.2, 100, 0) # rectangular channel
critical_depth(126, 1, 9.81, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
}

