% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_riverdistance.R
\name{plot.homerange}
\alias{plot.homerange}
\title{Plot Home Range}
\usage{
\method{plot}{homerange}(
  x,
  cumulative = FALSE,
  lwd = 3,
  maxlwd = 10,
  col = 4,
  pch = 21,
  label = FALSE,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An object returned from \link{homerange}.}

\item{cumulative}{Whether to plot travel as cumulative, with line thickness depending on the number of times a given region was traveled by a given individual.  Defaults to \code{FALSE}.}

\item{lwd}{The line width for plotting homerange, or minimum line width if \code{cumulative} is \code{TRUE}.  Defaults to 3.}

\item{maxlwd}{The maximum line width if \code{cumulative} is \code{TRUE}.  Defaults to 10.}

\item{col}{The line color to use.  Defaults to \code{"blue"}.}

\item{pch}{The point character to use for individual points.  Defaults to open circles, the color of lines.}

\item{label}{Whether to add survey labels to individual points, if used in \link{homerange}.  Defaults to \code{FALSE}.}

\item{main}{Plot title.  If the default \code{NULL} is used, plots will be titled according to unique individual.}

\item{...}{Additional plotting parameters, see \link{plot.rivernetwork}.}
}
\description{
Plotting method for home range, the minimum observed home range for multiple
  observations of each individual fish.
}
\examples{
data(Gulk, fakefish)
ranges <- with(fakefish, homerange(unique=fish.id, survey=flight, seg=seg, vert=vert, rivers=Gulk))
ranges

# 19 plots will be produced, recommend calling par(mfrow=c(4,5))
plot(ranges)
plot(ranges,cumulative=TRUE,label=TRUE)

homerangeoverlap(ranges)

plothomerangeoverlap(ranges)
with(fakefish, riverpoints(seg=seg, vert=vert, rivers=Gulk))
}
\seealso{
\link{homerange}, \link{homerangeoverlap}, \link{plothomerangeoverlap}
}
\author{
Matt Tyers
}
