% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{cr}
\alias{cr}
\alias{TN}
\title{Frequency of correct rejections or true negatives (TN).}
\format{An object of class \code{numeric} of length 1.}
\usage{
cr
}
\description{
\code{cr} is the frequency of correct rejections
or true negatives (\code{TN})
in a population of \code{\link{N}} individuals.
}
\details{
Definition:
\code{cr} is the frequency of individuals for which
\code{Condition = FALSE} and \code{Decision = FALSE} (negative).

\code{cr} is a measure of correct classifications,
not an individual case.

Relationships:
\enumerate{
\item to probabilities:
The frequency \code{cr} depends on the specificity \code{\link{spec}}
(aka. true negative rate, TNR)
and is conditional on the prevalence \code{\link{prev}}.

\item to other frequencies:
In a population of size \code{\link{N}}
the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond_true} + \link{cond_false}} (by condition)

\item \code{\link{N} = \link{dec_pos} + \link{dec_neg}} (by decision)

\item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
   }
}
}
\seealso{
\code{\link{spec}} is the specificity or correct rejection rate
(aka. true negative rate \code{\link{TNR}});
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{is_freq}} verifies frequencies.

Other essential parameters: \code{\link{fa}},
  \code{\link{hi}}, \code{\link{mi}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}

Other frequencies: \code{\link{N}},
  \code{\link{cond_false}}, \code{\link{cond_true}},
  \code{\link{dec_cor}}, \code{\link{dec_err}},
  \code{\link{dec_neg}}, \code{\link{dec_pos}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\concept{essential parameters}
\concept{frequencies}
\keyword{datasets}
