% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_dependencies.R
\name{assess_dependencies}
\alias{assess_dependencies}
\title{Assessment of dependency footprint for a specific package}
\usage{
assess_dependencies(x, ...)
}
\arguments{
\item{x}{a \code{pkg_ref} package reference object}

\item{...}{additional arguments passed on to S3 methods, rarely used}
}
\value{
a \code{pkg_metric} containing a dataframe of package names and they type of dependency the package being assess has to them
}
\description{
Only Depends, Imports and LinkingTo dependencies are assessed because
they are required
}
\details{
The more packages a package relies on the more chances for errors exist.
}
\examples{
\dontrun{
assess_dependencies(pkg_ref("riskmetric"))
}
}
\seealso{
\code{\link{metric_score.pkg_metric_dependencies}}
}
