% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHom.R
\name{as.PHom}
\alias{as.PHom}
\title{Convert to PHom Object}
\usage{
as.PHom(x, dim_col = 1, birth_col = 2, death_col = 3)
}
\arguments{
\item{x}{object being converted to \code{PHom} instance}

\item{dim_col}{either \code{integer} representing column index for feature
dimension data or \code{character} representing column name}

\item{birth_col}{either \code{integer} representing column index for feature
birth data or \code{character} representing column name}

\item{death_col}{either \code{integer} representing column index for feature
death data or \code{character} representing column name}
}
\value{
\code{PHom} instance
}
\description{
Converts valid objects to \code{PHom} instances.
}
\examples{
# construct data frame with valid persistence data
df <- data.frame(dimension = c(0, 0, 1, 1, 1, 2),
                 birth = rnorm(6),
                 death = rnorm(6, mean = 15))

# convert to `PHom` instance and print
df_phom <- as.PHom(df)
df_phom

# print feature details to confirm accuracy
print.data.frame(df_phom)
}
