% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition.R
\name{decomposition}
\alias{decomposition}
\title{Decomposition analysis}
\usage{
decomposition(outcome, betas, mm, ranker, wt, correction, citype = "CI")
}
\arguments{
\item{outcome}{Outcome variable}

\item{betas}{Beta coefficients from regression.}

\item{mm}{Model matrix from regression}

\item{ranker}{Ranking variable}

\item{wt}{Weights}

\item{correction}{Apply sign correction?}

\item{citype}{Character, CI type to be calculated, defaults to \code{CI}. Use \code{CIw} for binary outcomes.}
}
\value{
S3 object of class decomposition
}
\description{
Used by the wrapper \code{\link[=contribution]{contribution()}} but can be used manually. Calculates the decomposition for a given regression model.
}
\examples{
fit.lm = lm(mtcars$mpg ~ mtcars$cyl)
decomp = decomposition(mtcars$mpg, coefficients(fit.lm), fit.lm$model, 
                       mtcars$hp, wt = rep(1, nrow(mtcars)), correction = FALSE) 
summary(decomp)

}
