% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/federation_search.R
\name{federation_search}
\alias{federation_search}
\title{Federation search}
\usage{
federation_search(query, strict = FALSE, snippetCount = 0,
  expandSynonyms = TRUE, expandAcronyms = FALSE, expandAbbrevs = FALSE,
  expandInferred = TRUE, key = NULL, ...)
}
\arguments{
\item{query}{Query terms}

\item{strict}{(logical) Only consider more relevant columns.
Default: \code{FALSE}}

\item{snippetCount}{How many snippets to return. Default: 0}

\item{expandSynonyms}{(logical) Should recognized terms in the query have
synonyms expanded? Default: \code{TRUE}}

\item{expandAcronyms}{(logical) Default: \code{FALSE}}

\item{expandAbbrevs}{(logical) Default: \code{FALSE}}

\item{expandInferred}{(logical) Should recognized terms in the query have
inferred terms expanded? Default: \code{TRUE}}

\item{key}{(character) API key. required either passed in here or save
as an env var or R option. see \code{\link{rif}} and \code{\link{Startup}}}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Federation search
}
\examples{
\dontrun{
out <- federation_search("cellular")
out$query
out$messages
out$result$total
out$result$categories
head(out$result$results)

head( federation_search("cellular")$result$results )
head( federation_search("cellular", strict=TRUE)$result$results )
federation_search("cellular", snippetCount=3)

federation_search("cellular", verbose = TRUE)
}
}
\seealso{
Other federation: \code{\link{federation_data}},
  \code{\link{federation_facet}}
}
