% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-export.R
\name{write_psv}
\alias{write_psv}
\alias{read_psv}
\title{Read and write utilities}
\usage{
write_psv(x, dir, na_rows = NULL)

read_psv(dir, col_spec = NULL, id_var = "stay_id")
}
\arguments{
\item{x}{Object to write to files}

\item{dir}{Directory to write the (many) files to or read from}

\item{na_rows}{If \code{TRUE} missing time steps are filled with \code{NaN} values,
if \code{FALSE}, rows where all data columns entries are missing are removed and
if \code{NULL}, data is written as-is}

\item{col_spec}{A column specification as created by \code{\link[readr:cols]{readr::cols()}}}

\item{id_var}{Name of the id column (IDs are generated from file names)}
}
\value{
While \code{write_psv()} is called for side effects and returns \code{NULL}
invisibly, \code{read_psv()} returns an object inheriting from \code{id_tbl}.
}
\description{
Support for reading from and writing to pipe separated values (\code{.psv})
files as used for the PhysioNet Sepsis Challenge.
}
\details{
Data for the PhysioNet Sepsis Challenge is distributed as pipe separated
values (\code{.psv}) files, split into separate files per patient ID, containing
time stamped rows with measured variables as columns. Files are named with
patient IDs and do not contain any patient identifiers as data. Functions
\code{read_psv()} and \code{write_psv()} can be used to read from and write to such
a data format.
}
\references{
Reyna, M., Josef, C., Jeter, R., Shashikumar, S., Moody, B., Westover, M.
B., Sharma, A., Nemati, S., & Clifford, G. (2019). Early Prediction of
Sepsis from Clinical Data -- the PhysioNet Computing in Cardiology
Challenge 2019 (version 1.0.0). PhysioNet.
https://doi.org/10.13026/v64v-d857.
}
