% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{p.range}
\alias{p.range}
\title{Probability of a date lying within a cal BP range}
\usage{
p.range(
  x1,
  x2,
  y,
  er,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  normal = TRUE,
  as.F = FALSE,
  is.F = FALSE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  threshold = 0
)
}
\arguments{
\item{x1}{The start the range of interest.}

\item{x2}{The end of the range of interest.}

\item{y}{The radiocarbon date's mean.}

\item{er}{The radiocarbon date's lab error.}

\item{cc}{calibration curve for the radiocarbon date(s) (see the \code{rintcal} package).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{as.F}{Whether or not to calculate ages in the F14C timescale. Defaults to \code{as.F=FALSE}, which uses the C14 timescale.}

\item{is.F}{Use this if the provided date is in the F14C timescale.}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=0}.}
}
\value{
The probability of a date lying within a certain calendar age range.
}
\description{
Find the probability of a calibrated date lying within an age range
}
\details{
The function can only deal with one date at a time.
}
\examples{
p.range(2800, 2400, 2450, 20)
}
\author{
Maarten Blaauw
}
