% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{relevelsByNamedVec}
\alias{relevelsByNamedVec}
\title{Relevel a factor by a named vector.}
\usage{
relevelsByNamedVec(
  x,
  refs,
  missingLevels = c("pass", "warning", "error"),
  unrecognisedLevels = c("warning", "pass", "error")
)
}
\arguments{
\item{x}{A factor}

\item{refs}{A named vector. The names of the vector are all or a subset of
levels in the old factor. And the values are new levels}

\item{missingLevels}{Actions taken in case existing levels are missing:
'pass', 'warning', or 'error'.}

\item{unrecognisedLevels}{Actions taken in case unrecognised levels are
found: 'pass', 'warning', or 'error'.}
}
\value{
A vector of factor
}
\description{
If names contain character strings other than the levels in the old factor
and warning is set to \code{TRUE}, a warning will be raised.
}
\details{
The levels of the factor are the names of the \code{ref} vector, and
the order of the \code{ref} vector matters: it is the levels of the new factor.
}
\examples{

oldFactor <- factor(c("A", "B", "A", "C", "B"), levels=LETTERS[1:3])
factorDict <- c("A"="a", "B"="b", "C"="c")
newFactor <- relevelsByNamedVec(oldFactor, factorDict)
stopifnot(identical(newFactor, factor(c("a", "b", "a", "c", "b"), levels=c("a", "b", "c"))))
## TODO: test warning and error

}
