% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{cumJaccardIndex}
\alias{cumJaccardIndex}
\alias{cumJaccardDistance}
\title{Cumulative Jaccard Index}
\usage{
cumJaccardIndex(list)

cumJaccardDistance(list)
}
\arguments{
\item{list}{A list of characters or integers}
}
\value{
The cumulative Jaccard Index, a vector of values between 0 and 1, of
the same length as the input list

The cumulative Jaccard Index is calculated by calculating the Jaccard Index
of element \code{i} and the union of elements between \code{1} and
\code{i-1}. The cumulative Jaccard Index of the first element is set as 0.0.

The cumulative Jaccard distance is defined in almost the same way, with the
only difference the distance is returned. The value of the first element is
1.0.
}
\description{
Cumulative Jaccard Index
}
\note{
An advantage of using cumulative overlap coefficient over cumulative
Jaccard Index is that it is monotonic: the value is garanteed to decrease
from 1 to 0, whereas the cumulative Jaccard Index may not be monotic.
}
\examples{

myList <- list(first=LETTERS[1:5], second=LETTERS[6:10], third=LETTERS[8:12], fourth=LETTERS[1:12])
cumJaccardIndex(myList)
cumJaccardDistance(myList)

}
\seealso{
\code{\link{cumOverlapCoefficient}}
}
