% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-scalers.R
\name{MinMaxScaler}
\alias{MinMaxScaler}
\title{Transforms features by scaling each feature to a given range}
\description{
This estimator scales and translates each feature individually such that it
is in the given range on the training set, e.g. between zero and one.

The transformation is given by:

\if{html}{\out{<div class="sourceCode">}}\preformatted{X_std = (X - X.min(axis=0)) / (X.max(axis=0) - X.min(axis=0))
X_scaled = X_std * (max - min) + min
}\if{html}{\out{</div>}}

where \verb{min, max = feature_range}.

This transformation is often used as an alternative to zero mean, unit
variance scaling.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.preprocessing")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mms <- MinMaxScaler$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseScaler]{rgudhi::BaseScaler}} -> \code{MinMaxScaler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MinMaxScaler-new}{\code{MinMaxScaler$new()}}
\item \href{#method-MinMaxScaler-clone}{\code{MinMaxScaler$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinMaxScaler-new"></a>}}
\if{latex}{\out{\hypertarget{method-MinMaxScaler-new}{}}}
\subsection{Method \code{new()}}{
The \link{MinMaxScaler} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinMaxScaler$new(feature_range = c(0, 1), copy = TRUE, clip = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_range}}{A length-2 numeric vector specifying the desired
range of transformed data. Defaults to \code{c(0, 1)}.}

\item{\code{copy}}{A boolean value specifying whether to perform in-place
scaling and avoid a copy (if the input is already a numpy array).
Defaults to \code{TRUE}.}

\item{\code{clip}}{A boolean value specifying whether to clip transformed values
of held-out data to provided \code{feature_range}. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{MinMaxScaler}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MinMaxScaler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MinMaxScaler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinMaxScaler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
