% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpat_create_grid.R
\name{gpat_create_grid}
\alias{gpat_create_grid}
\title{Grid polygon creator}
\usage{
gpat_create_grid(x, brick = FALSE)
}
\arguments{
\item{x}{A filepath to the geoPAT 2.0 grid header file}

\item{brick}{TRUE/FALSE; should a new grid polygon have a brick topology}
}
\value{
sfc_POLYGON
}
\description{
Creates a polygon of a geoPAT grid based on the grid header
}
\examples{
header_filepath = system.file("rawdata/Augusta2011_grid100.hdr", package="rgeopat2")
my_grid = gpat_create_grid(header_filepath)
my_grid_brick = gpat_create_grid(header_filepath, brick = TRUE)

plot(my_grid)
plot(my_grid_brick, add = TRUE, border = "red", lwd = 3)

}
