% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_geoda.R
\docType{class}
\name{geoda-class}
\alias{geoda-class}
\alias{geoda}
\title{'geoda' class}
\description{
'geoda' is a RefClass that wraps the C++ GeoDa class (via p_GeoDa defines in rgeoda.R)
}
\section{Fields}{

\describe{
\item{\code{gda}}{The pointer to the instance of p_GeoDa-class}

\item{\code{map_type}}{The map type, could be either Point or Polygon}

\item{\code{n_cols}}{The number of columns}

\item{\code{n_obs}}{The number of observations}

\item{\code{field_names}}{A string vector of field names}

\item{\code{field_types}}{A string vector of field types  (integer, real, string)}
}}

\section{Methods}{

\describe{
\item{\code{GetFieldNames(...)}}{Get the field names of all columns}

\item{\code{GetFieldTypes(...)}}{Get the field types (integer, real, string) of all columns}

\item{\code{GetIntegerCol(col_name)}}{Get the integer values from a column}

\item{\code{GetMapType(...)}}{Get the map type}

\item{\code{GetNumCols(...)}}{Get the number of columns}

\item{\code{GetNumObs(...)}}{Get the number of observations}

\item{\code{GetPointer()}}{Get the C++ object pointer (internally used)}

\item{\code{GetRealCol(col_name)}}{Get the real values from a column}

\item{\code{GetUndefinedVals(col_name)}}{Get the undefined flags from a column}

\item{\code{initialize(o_gda)}}{Constructor with a geoda object (internally used)}
}}

