% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations.r
\name{organizations}
\alias{organizations}
\title{Organizations metadata.}
\usage{
organizations(
  data = "all",
  country = NULL,
  uuid = NULL,
  query = NULL,
  limit = 100,
  start = NULL,
  curlopts = list()
)
}
\arguments{
\item{data}{(character) The type of data to get. One or more of:
'organization', 'contact', 'endpoint', 'identifier', 'tag', 'machineTag',
'comment', 'hostedDataset', 'ownedDataset', 'deleted', 'pending',
'nonPublishing', or the special 'all'. Default: \code{'all'}}

\item{country}{(character) Filters by country as given in isocodes$code,
e.g. \code{country="CA"}}

\item{uuid}{(character) UUID of the data node provider. This must be
specified if data is anything other than 'all', 'deleted', 'pending', or
'nonPublishing'.}

\item{query}{(character) Query nodes. Only used when \code{data='all'}}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A list of length of two, consisting of a data.frame \code{meta} when
uuid is NULL, and \code{data} which can either be a list or a data.frame
depending on the requested type of data.
}
\description{
Organizations metadata.
}
\examples{
\dontrun{
organizations(limit=5)
organizations(query="france", limit=5)
organizations(country = "SPAIN")
organizations(uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")
organizations(data='contact', uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")
organizations(data='pending')
organizations(data=c('contact','endpoint'),
  uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")

# Pass on curl options
organizations(query="spain", curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/registry#organizations}
}
