% Generated by roxygen2 (4.0.2): do not edit by hand
\name{name_usage}
\alias{name_usage}
\title{Lookup details for specific names in all taxonomies in GBIF.}
\usage{
name_usage(key = NULL, name = NULL, data = "all", language = NULL,
  datasetKey = NULL, uuid = NULL, sourceId = NULL, rank = NULL,
  shortname = NULL, start = NULL, limit = 100, ...)
}
\arguments{
\item{key}{(numeric) A GBIF key for a taxon}

\item{name}{(character) Filters by a case insensitive, canonical namestring,
e.g. 'Puma concolor'}

\item{data}{(character) Specify an option to select what data is returned. See Description
below.}

\item{language}{(character) Language, default is english}

\item{datasetKey}{(character) Filters by the dataset's key (a uuid)}

\item{uuid}{(character) A uuid for a dataset. Should give exact same results as datasetKey.}

\item{sourceId}{(numeric) Filters by the source identifier. Not used right now.}

\item{rank}{(character) Taxonomic rank. Filters by taxonomic rank as one of:
  CLASS, CULTIVAR, CULTIVAR_GROUP, DOMAIN, FAMILY, FORM, GENUS, INFORMAL,
  INFRAGENERIC_NAME, INFRAORDER, INFRASPECIFIC_NAME, INFRASUBSPECIFIC_NAME,
KINGDOM, ORDER, PHYLUM, SECTION, SERIES, SPECIES, STRAIN, SUBCLASS, SUBFAMILY,
SUBFORM, SUBGENUS, SUBKINGDOM, SUBORDER, SUBPHYLUM, SUBSECTION, SUBSERIES,
SUBSPECIES, SUBTRIBE, SUBVARIETY, SUPERCLASS, SUPERFAMILY, SUPERORDER,
SUPERPHYLUM, SUPRAGENERIC_NAME, TRIBE, UNRANKED, VARIETY}

\item{shortname}{(character) A short name..need more info on this?}

\item{start}{Record number to start at. Use in combination with limit to page through results.
Note that in \code{\link{occ_search}} we do the paging internally for you, so there's no
\code{start} parameeter, but in other functions you have to do paging yourself.}

\item{limit}{Number of records to return. Defaults: For \code{\link{occ_search}} 500, for others
100. Maximum: 1,000,000 records for \code{\link{occ_search}}, others, don't know yet.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\value{
A list of length two. The first element is metadata. The second is
either a data.frame (verbose=FALSE, default) or a list (verbose=TRUE)
}
\description{
This service uses fuzzy lookup so that you can put in partial names and
you should get back those things that match. See examples below.

This function is different from \code{name_lookup} in that that function
searches for names, while this function requires that you already have a key.

Note that verbatim hasn't been working

Options for the data parameter are: 'all', 'verbatim', 'name', 'parents', 'children',
'related', 'synonyms', 'descriptions','distributions', 'images',
'references', 'speciesProfiles', 'vernacularNames', 'typeSpecimens', 'root'
}
\examples{
\dontrun{
# All name usages
name_usage()

# A single name usage
name_usage(key=1)

# Name usage for a taxonomic name
name_usage(name='Puma concolor')
name_usage(name='Puma', rank="GENUS")

# References for a name usage
name_usage(key=3119195, data='references')

# Species profiles, descriptions
name_usage(key=3119195, data='speciesProfiles')
name_usage(key=3119195, data='descriptions')
res <- name_usage(key=2435099, data='children')
sapply(res$results, "[[", "scientificName")

# Vernacular names for a name usage
name_usage(key=3119195, data='vernacularNames')

# Limit number of results returned
name_usage(key=3119195, data='vernacularNames', limit=3)

# Search for names by dataset with datasetKey parameter
name_usage(datasetKey="d7dddbf4-2cf0-4f39-9b2a-bb099caae36c")

# Search for a particular language
name_usage(key=3119195, language="FRENCH", data='vernacularNames')

# Pass on httr options
library('httr')
res <- name_usage(name='Puma concolor', limit=300, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/species#nameUsages}
}

