/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.integer.IntAffineView;

public class Task {
    private final IntVar start;
    private final IntVar duration;
    private final IntVar end;
    private IVariableMonitor<IntVar> update;

    public Task(Model model, int est, int lst, int d, int ect, int lct) {
        this.start = model.intVar(est, lst);
        this.duration = model.intVar(d);
        if (ect == est + d && lct == lst + d) {
            this.end = this.start.getModel().offset(this.start, d);
        } else {
            this.end = model.intVar(ect, lct);
            this.declareMonitor();
        }
    }

    public Task(IntVar s, int d) {
        this.start = s;
        this.duration = this.start.getModel().intVar(d);
        this.end = this.start.getModel().offset(this.start, d);
    }

    public Task(IntVar s, int d, IntVar e) {
        this.start = s;
        this.duration = this.start.getModel().intVar(d);
        this.end = e;
        if (!Task.isOffsetView(s, d, e)) {
            this.declareMonitor();
        }
    }

    public Task(IntVar s, IntVar d, IntVar e) {
        this.start = s;
        this.duration = d;
        this.end = e;
        if (!d.isInstantiated() || !Task.isOffsetView(s, d.getValue(), e)) {
            this.declareMonitor();
        }
    }

    private static boolean isOffsetView(IntVar s, int d, IntVar e) {
        if (e instanceof IntAffineView) {
            IntAffineView intOffsetView = (IntAffineView)e;
            return intOffsetView.equals(s, 1, d);
        }
        return false;
    }

    private void declareMonitor() {
        this.update = this.start.hasEnumeratedDomain() || this.duration.hasEnumeratedDomain() || this.end.hasEnumeratedDomain() ? new TaskMonitor(this.start, this.duration, this.end, true) : new TaskMonitor(this.start, this.duration, this.end, false);
        Model model = this.start.getModel();
        ArrayList<Task> tset = (ArrayList<Task>)model.getHook("H_TASKSET");
        if (tset == null) {
            tset = new ArrayList<Task>();
            model.addHook("H_TASKSET", tset);
        }
        tset.add(this);
    }

    public void ensureBoundConsistency() throws ContradictionException {
        this.update.onUpdate(this.start, IntEventType.REMOVE);
    }

    public IntVar getStart() {
        return this.start;
    }

    public IntVar getDuration() {
        return this.duration;
    }

    public IntVar getEnd() {
        return this.end;
    }

    public IVariableMonitor<IntVar> getMonitor() {
        return this.update;
    }

    public String toString() {
        return "Task[start=" + this.start + ", duration=" + this.duration + ", end=" + this.end + ']';
    }

    private static class TaskMonitor
    implements IVariableMonitor<IntVar> {
        private final IntVar S;
        private final IntVar D;
        private final IntVar E;
        private final boolean isEnum;

        private TaskMonitor(IntVar S, IntVar D2, IntVar E, boolean isEnum) {
            this.S = S;
            this.D = D2;
            this.E = E;
            S.addMonitor(this);
            D2.addMonitor(this);
            E.addMonitor(this);
            this.isEnum = isEnum;
        }

        @Override
        public void onUpdate(IntVar var, IEventType evt) throws ContradictionException {
            boolean lcg = var.getModel().getSolver().isLCG();
            do {
                boolean fixpoint = this.S.updateLowerBound(this.E.getLB() - this.D.getUB(), this, lcg ? Reason.r(this.E.getMinLit(), this.D.getMaxLit()) : Reason.undef());
                fixpoint |= this.S.updateUpperBound(this.E.getUB() - this.D.getLB(), this, lcg ? Reason.r(this.E.getMaxLit(), this.D.getMinLit()) : Reason.undef());
                fixpoint |= this.E.updateLowerBound(this.S.getLB() + this.D.getLB(), this, lcg ? Reason.r(this.S.getMinLit(), this.D.getMinLit()) : Reason.undef());
                fixpoint |= this.E.updateUpperBound(this.S.getUB() + this.D.getUB(), this, lcg ? Reason.r(this.S.getMaxLit(), this.D.getMaxLit()) : Reason.undef());
                fixpoint |= this.D.updateLowerBound(this.E.getLB() - this.S.getUB(), this, lcg ? Reason.r(this.E.getMinLit(), this.S.getMaxLit()) : Reason.undef());
            } while ((fixpoint |= this.D.updateUpperBound(this.E.getUB() - this.S.getLB(), this, lcg ? Reason.r(this.E.getMaxLit(), this.S.getMinLit()) : Reason.undef())) && this.isEnum);
        }

        @Override
        public void forEachIntVar(Consumer<IntVar> action) {
            action.accept(this.S);
            action.accept(this.D);
            action.accept(this.E);
        }

        public String toString() {
            return "Task[" + this.S.getName() + "+" + this.D.getName() + "=" + this.E.getName() + "]";
        }
    }
}

