/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import org.chocosolver.solver.constraints.nary.knapsack.structure.ProfitInterface;
import org.chocosolver.solver.constraints.nary.knapsack.structure.WeightInterface;

public class KPItem
implements WeightInterface,
ProfitInterface {
    private final int profit;
    private int weight;
    private boolean active;

    public KPItem(int profit, int weight) {
        this.profit = profit;
        this.weight = weight;
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }

    @Override
    public int getProfit() {
        return this.active ? this.profit : 0;
    }

    public int getActivatedWeight() {
        return this.weight;
    }

    public int getActivatedProfit() {
        return this.profit;
    }

    @Override
    public int getWeight() {
        return this.active ? this.weight : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public double getEfficiency() {
        return this.active ? (double)this.getProfit() / (double)this.getWeight() : 0.0;
    }
}

