/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.lex;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropLexChain
extends Propagator<IntVar> {
    private final int N;
    private final int M;
    private final int[][] UB;
    private final int[][] LB;
    private final boolean strict;
    private final IntVar[][] x;

    public PropLexChain(IntVar[][] variables, boolean strict) {
        super((Variable[])ArrayUtils.flatten(variables), (Priority)PropagatorPriority.LINEAR, true);
        this.M = variables.length;
        this.N = variables[0].length;
        this.x = new IntVar[this.M][this.N];
        int p = 0;
        for (int i = 0; i < this.M; ++i) {
            System.arraycopy(this.vars, p, this.x[i], 0, this.N);
            p += this.N;
        }
        this.strict = strict;
        this.UB = new int[this.M][this.N];
        this.LB = new int[this.M][this.N];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.N; ++i) {
                this.UB[this.M - 1][i] = this.x[this.M - 1][i].getUB();
            }
            for (i = this.M - 2; i >= 0; --i) {
                this.computeUB(this.x[i], this.UB[i + 1], this.UB[i]);
            }
            for (i = 0; i < this.N; ++i) {
                this.LB[0][i] = this.x[0][i].getLB();
            }
            for (i = 1; i < this.M; ++i) {
                this.computeLB(this.x[i], this.LB[i - 1], this.LB[i]);
            }
        }
        for (i = 0; i < this.M; ++i) {
            this.boundsLex(this.LB[i], this.x[i], this.UB[i]);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        int i;
        int vec_idx = idxVarInProp % this.M;
        if (IntEventType.isDecupp(mask)) {
            for (i = 0; i < this.N; ++i) {
                this.UB[vec_idx][i] = this.x[vec_idx][i].getUB();
            }
            for (i = vec_idx - 1; i >= 0; --i) {
                this.computeUB(this.x[i], this.UB[i + 1], this.UB[i]);
            }
        }
        if (IntEventType.isInclow(mask)) {
            for (i = 0; i < this.N; ++i) {
                this.LB[vec_idx][i] = this.x[vec_idx][i].getLB();
            }
            for (i = vec_idx + 1; i < this.M; ++i) {
                this.computeLB(this.x[i], this.LB[i - 1], this.LB[i]);
            }
        }
        this.forcePropagate(PropagatorEventType.FULL_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.checkTuple(0));
        }
        return ESat.UNDEFINED;
    }

    private boolean checkTuple(int i) {
        if (i == this.x.length - 1) {
            return true;
        }
        int index = this.N * i;
        int j = 0;
        while (j < this.N) {
            if (((IntVar[])this.vars)[index].getValue() > ((IntVar[])this.vars)[index + this.N].getValue()) {
                return false;
            }
            if (((IntVar[])this.vars)[index].getValue() < ((IntVar[])this.vars)[index + this.N].getValue()) {
                return this.checkTuple(i + 1);
            }
            ++j;
            ++index;
        }
        return !this.strict && this.checkTuple(i + 1);
    }

    private void boundsLex(int[] a2, IntVar[] x, int[] b) throws ContradictionException {
        int i;
        for (i = 0; i < this.N && a2[i] == b[i]; ++i) {
            x[i].updateBounds(a2[i], b[i], this);
        }
        if (i < this.N) {
            x[i].updateBounds(a2[i], b[i], this);
        }
        if (i == this.N || x[i].nextValue(a2[i]) < b[i]) {
            return;
        }
        ++i;
        while (i < this.N && x[i].getLB() == b[i] && x[i].getUB() == a2[i]) {
            if (x[i].hasEnumeratedDomain()) {
                x[i].removeInterval(b[i] + 1, a2[i] - 1, this);
            }
            ++i;
        }
        if (i < this.N && x[i].hasEnumeratedDomain()) {
            x[i].removeInterval(b[i] + 1, a2[i] - 1, this);
        }
    }

    private int computeAlpha(IntVar[] x, int[] b) throws ContradictionException {
        int i;
        int alpha = -1;
        for (i = 0; i < this.N && x[i].contains(b[i]); ++i) {
            if (b[i] <= x[i].getLB()) continue;
            alpha = i;
        }
        if (!this.strict) {
            if (i == this.N || b[i] > x[i].getLB()) {
                alpha = i;
            }
        } else if (i < this.N && b[i] > x[i].getLB()) {
            alpha = i;
        }
        return alpha;
    }

    private int computeBeta(IntVar[] x, int[] a2) throws ContradictionException {
        int i;
        int beta = -1;
        for (i = 0; i < this.N && x[i].contains(a2[i]); ++i) {
            if (a2[i] >= x[i].getUB()) continue;
            beta = i;
        }
        if (!this.strict) {
            if (i == this.N || a2[i] < x[i].getUB()) {
                beta = i;
            }
        } else if (i < this.N && a2[i] < x[i].getUB()) {
            beta = i;
        }
        return beta;
    }

    private void computeUB(IntVar[] x, int[] b, int[] u) throws ContradictionException {
        int alpha = this.computeAlpha(x, b);
        if (alpha == -1) {
            this.fails();
        }
        for (int i = 0; i < this.N; ++i) {
            u[i] = i < alpha ? b[i] : (i == alpha ? x[i].previousValue(b[i]) : x[i].getUB());
        }
    }

    private void computeLB(IntVar[] x, int[] a2, int[] lower) throws ContradictionException {
        int beta = this.computeBeta(x, a2);
        if (beta == -1) {
            this.fails();
        }
        for (int i = 0; i < this.N; ++i) {
            lower[i] = i < beta ? a2[i] : (i == beta ? x[i].nextValue(a2[i]) : x[i].getLB());
        }
    }
}

