% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-tools.R
\name{gb_extract}
\alias{gb_extract}
\title{Extract elements of a GenBank record}
\usage{
gb_extract(
  record,
  what = c("accession", "version", "organism", "sequence", "definition", "locus",
    "features", "keywords")
)
}
\arguments{
\item{record}{GenBank record in text format, character}

\item{what}{Which element to extract}
}
\value{
character or list of lists (what='features') or named character
vector (what='locus')
}
\description{
Return elements of GenBank record e.g. sequence, definition ...
}
\details{
This function uses a REGEX to extract particular elements of a
GenBank record. All of the what options return a single character with the
exception of 'locus' or 'keywords' that return character vectors and
'features' that returns a list of lists for all features.

The accuracy of these functions cannot be guaranteed due to the enormity of
the GenBank database. But the function is regularly tested on a range of
GenBank records.

Note: all non-latin1 characters are converted to '-'.
}
\examples{
library(restez)
data('record')
(gb_extract(record = record, what = 'locus'))
}
\concept{parse}
