% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImportance.R
\name{FeatureImportance}
\alias{FeatureImportance}
\title{Compute Feature Importance of a RerF model}
\usage{
FeatureImportance(forest, num.cores = 0L, type = NULL)
}
\arguments{
\item{forest}{a forest trained using the RerF function with argument store.impurity = TRUE}

\item{num.cores}{number of cores to use. If num.cores = 0, then 1 less than the number of cores reported by the OS are used. (num.cores = 0)}

\item{type}{character string specifying which method to use in
calculating feature importance.
\describe{
  \item{'C'}{specifies that unique combinations of features
  should be *c*ounted across trees.}
  \item{'R'}{feature importance will be calculated as in *R*andomForest.}
  \item{'E'}{calculates the unique projections up to *e*quivalence if
  the vector of projection weights parametrizes the same line in
  \eqn{R^p}.}
}}
}
\value{
a list with 3 elements, 
\describe{
  \item{\code{imp}}{The vector of scores/counts, corresponding to each feature.}
  \item{\code{features}}{The features/projections used.}
  \item{\code{type}}{The code for the method used.}
  }
}
\description{
Computes feature importance of every unique feature used to make a split in the RerF model.
}
\examples{
library(rerf)
num.cores <- 1L
forest <- RerF(as.matrix(iris[, 1:4]), iris[[5L]], num.cores = 1L, store.impurity = TRUE)

imp.C <- FeatureImportance(forest, num.cores, "C")
imp.R <- FeatureImportance(forest, num.cores, "R")
imp.E <- FeatureImportance(forest, num.cores, "E")

fRF <- RerF(as.matrix(iris[, 1:4]), iris[[5L]],
            FUN = RandMatRF, num.cores = 1L, store.impurity = TRUE)

fRF.imp <- FeatureImportance(forest = fRF, num.cores = num.cores)

}
