% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{fixErrors}
\alias{fixErrors}
\alias{fixErrors.default}
\alias{fixErrors.Raster}
\alias{fixErrors.SpatialPolygons}
\alias{fixErrors.sf}
\title{Do some minor error fixing}
\usage{
fixErrors(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

\method{fixErrors}{default}(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

\method{fixErrors}{Raster}(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

\method{fixErrors}{SpatialPolygons}(
  x,
  objectName = NULL,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

\method{fixErrors}{sf}(
  x,
  objectName = NULL,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)
}
\arguments{
\item{x}{A \code{SpatialPolygons*} or \code{sf} object.}

\item{objectName}{Optional. This is only for messaging; if provided, then messages relayed
to user will mention this.}

\item{attemptErrorFixes}{Will attempt to fix known errors. Currently only some failures
for \code{SpatialPolygons*} are attempted.
Notably with \code{terra::buffer(..., width = 0)}.
Default \code{TRUE}, though this may not be the right action for all cases.}

\item{useCache}{Logical, default \code{getOption("reproducible.useCache", FALSE)}, whether
Cache is used on the internal \code{terra::buffer} command.}

\item{testValidity}{Logical. If \code{TRUE}, the a test for validity will happen
before actually running buffering (which is the solution in most
cases). However, sometimes it takes longer to test for validity
than just buffer without testing (there are no consequences of
buffering if everything is valid). If \code{FALSE}, then the
test will be skipped and the buffering will happen regardless.
If \code{NA}, then all testing and buffering will be skipped.}

\item{...}{Passed to methods. None currently implemented.}
}
\description{
These must be very common for this function to be useful. Currently, the only
meaningful method is on \code{SpatialPolygons}, and it runs \code{sf::st_is_valid}.
If \code{FALSE}, then it runs  \code{st_make_valid} or \code{terra::buffer},
depending on whether x is \code{sf} or \code{SpatialPolygons*}, respectively.

This uses \code{terra::buffer(..., width = 0)} internally, which fixes some
failures to \code{sf::st_is_valid}
}
\examples{
# Add a study area to Crop and Mask to
# Create a "study area"
library(sp)
library(raster)
ow <- setwd(tempdir())

# make a SpatialPolygon
coords1 <- structure(c(-123.98, -117.1, -80.2, -100, -123.98, 60.9, 67.73, 65.58, 51.79, 60.9),
                     .Dim = c(5L, 2L))
Sr1 <- Polygon(coords1)
Srs1 <- Polygons(list(Sr1), "s1")
shpEcozone <- SpatialPolygons(list(Srs1), 1L)
crs(shpEcozone) <- "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

# make a "study area" that is subset of larger dataset
coords <- structure(c(-118.98, -116.1, -99.2, -106, -118.98, 59.9, 65.73, 63.58, 54.79, 59.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords)
Srs1 <- Polygons(list(Sr1), "s1")
StudyArea <- SpatialPolygons(list(Srs1), 1L)
crs(StudyArea) <- crs(shpEcozone)
projString <- "+proj=utm +zone=15 +ellps=GRS80 +datum=NAD83 +units=m +no_defs"
StudyArea <- sp::spTransform(StudyArea, CRSobj = projString)

##########
shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)


# Try manually, individual pieces
shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)
shpEcozoneClean <- fixErrors(shpEcozone)
shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)

# With terra
if (require("terra")) {
  opts <- options("reproducible.useTerra" = TRUE)
  vectEcozone <- terra::vect(sf::st_as_sf(shpEcozone)) # direct conversion throws warning

  # If input is Spatial object --> return will also be Spatial
  shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)
  # Try manually, individual pieces -- Note functions are different
  shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
  shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)
  shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)

  # If input is Spat object --> return will also be Spat
  vectEcozonePostProcessed <- postProcess(vectEcozone, studyArea = StudyArea)
  # Try manually, individual pieces -- Note functions are different
  vectEcozoneMasked <- maskInputs(vectEcozone, StudyArea)
  VectEcozoneReprojected <- projectInputs(vectEcozone, StudyArea)
  vectEcozoneCropped <- cropInputs(vectEcozone, StudyArea)



  # Note these two have different function names --> methods for cropInputs and fixErrors
  #    are not implemented yet
  shpEcozoneClean <- fixErrorsTerra(vectEcozone)

  options(opts)
}

setwd(ow)
}
\keyword{internal}
