% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess}
\alias{preProcess}
\title{Download, Checksum, Extract files}
\usage{
preProcess(targetFile = NULL, url = NULL, archive = NULL,
  alsoExtract = NULL, destinationPath = ".", fun = NULL,
  quick = getOption("reproducible.quick"), overwrite = FALSE,
  purge = FALSE, useCache = getOption("reproducible.useCache", FALSE), ...)
}
\arguments{
\item{targetFile}{Character string giving the path to the eventual file
(raster, shapefile, csv, etc.) after downloading and extracting from a zip
or tar archive. This is the file \emph{before} it is passed to
\code{postProcess}. Currently, the internal checksumming does not checksum
the file after it is \code{postProcess}ed (e.g., cropped/reprojected/masked).
Using \code{Cache} around \code{prepInputs} will do a sufficient job in these cases.}

\item{url}{Optional character string indicating the URL to download from.
Normally, if used within a module, this url should be explicitly given as
sourceURL for an \code{expectsInput}. In that case, it will use the
module's checksums file to confirm that the download occurred correctly. If
URL is used here, an ad hoc checksums will be created in the
\code{destinationPath}. This will be used in subsequent calls to
\code{prepInputs}, comparing the file on hand with the ad hoc
\code{CHECKSUMS.txt}.}

\item{archive}{Optional character string giving the path of an archive
containing \code{targetFile}, or a vector giving a set of nested archives
(e.g., \code{c("xxx.tar", "inner.zip")}). If there is/are (an) inner
archive(s), but they are unknown, the function will try all until it finds
the \code{targetFile}}

\item{alsoExtract}{Optional character string naming files other than
\code{targetFile} that must be extracted from the \code{archive}.}

\item{destinationPath}{Character string of a directory in which to download
and save the file that comes from \code{url} and is also where the function
will look for \code{archive} or \code{targetFile}.}

\item{fun}{Character string indicating the function to use to load
\code{targetFile} into an \code{R} object.}

\item{quick}{Logical. This is passed internally to \code{\link{Checksums}}
(the quickCheck argument), and to
\code{\link{Cache}} (the quick argument). This results in faster, though
less robust checking of inputs. See the respective functions.}

\item{overwrite}{Logical. Should downloading and all the other actions occur
even if they pass the checksums or the files are all there.}

\item{purge}{Logical or Integer. \code{0/FALSE} (default) keeps existing
\code{CHECKSUMS.txt} file and
\code{prepInputs} will write or append to it. \code{1/TRUE} will deleted the entire
\code{CHECKSUMS.txt} file. Other options, see details.}

\item{useCache}{Passed to Cache in various places. Default \code{FALSE}}

\item{...}{Additional arguments passed to \code{fun} (i.e,. user supplied),
 \code{\link{postProcess}} and \code{\link[reproducible]{Cache}}.
Since \code{...} is passed to \code{\link{postProcess}}, these will
\code{...} will also be passed into the inner
functions, e.g., \code{\link{cropInputs}}. See details and examples.}
}
\value{
A list with 5 elements, \code{checkSums} (the result of a \code{Checksums}
after downloading), \code{dots} (cleaned up ..., including deprecated argument checks),
\code{fun} (the function to be used to load the preProcessed object from disk),
\code{targetFilePath} (the fully qualified path to the \code{targetFile}),
and \code{tryRasterFn} (a logical whether the the \code{targetFilePath}
should be loaded with \code{\link[raster]{raster}}).
}
\description{
This does downloading (via \code{downloadFile}), checksumming (\code{Checksums}),
and extracting from archives (\code{extractFromArchive}), plus cleaning up of input
arguments (e.g., paths, function names).
This is the first stage of three used in \code{prepInputs}.
}
\author{
Eliot McIntire
}
