% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KitchenhamMadeyskiBudgen16.COCOMO}
\alias{KitchenhamMadeyskiBudgen16.COCOMO}
\title{KitchenhamMadeyskiBudgen16.COCOMO data}
\format{A data frame with variables:
\describe{
\item{Project}{Project ID}
\item{Type}{A categorical variable describing the type of the project}
\item{Year}{The year the project was completed}
\item{Lang}{A categorical variable describing the development language used}
\item{Rely}{Ordinal value defining the required software reliability}
\item{Data}{Ordinal value defining the data complexity / Data base size}
\item{Cplx}{Ordinal value defining the complexity of the software / Process complexity}
\item{Aaf}{??}
\item{Time}{Ordinal value defining the stringency of timing constraints / Time constraint for cpu}
\item{Stor}{Ordinal value defining the stringency of the data storage requirements / Main memory constraint}
\item{Virt}{Virtual Machine volatility}
\item{Turn}{Turnaround time}
\item{Type2}{A categorical variable defining the hardware type: mini, max=mainframe, midi}
\item{Acap}{Ordinal value defining the analyst capability}
\item{Aexp}{Ordinal value defining the analyst experience / application experience}
\item{Pcap}{Ordinal value defining the programming capability of the team / Programmers capability}
\item{Vexp}{Ordinal value defining the virtual machine experience of the team}
\item{Lexp}{Ordinal value defining the programming language experience of the team}
\item{Cont}{??}
\item{Modp}{ / Modern programing practices}
\item{Tool}{Ordinal value defining the extent of tool use / Use of software tools}
\item{ToolCat}{Recoding of Tool to labelled ordinal scale}
\item{Sced}{Ordinal value defining the stringency of the schedule requirements / Schedule constraint}
\item{Rvol}{Ordinal value defining the requriements volatility of the project}
\item{Select}{Categorical value calculated by BAK for an analysis example}
\item{Rvolcat}{Recoding of Rvol to a labelled ordinal scale}
\item{Modecat}{Mode of the projects: O=Organic, E=Embedded, SD-Semi-Detached}
\item{Mode1}{Dummy variable calculated by BAK: 1 if the project is Organic, 0 otherwise}
\item{Mode2}{Dummy variable calculated by BAK: 1 if the project is Semi-detached, 0 otherwise}
\item{Mode3}{Dummy variable calculated by BAK: 1 if the project is Embedded, 0 otherwise}
\item{KDSI}{Product Size Thousand of Source Instructions}
\item{AKDSI}{Adjusted Product Size for Project in Thousand Source Instructions - differs from KDSI for enhancement projects}
\item{Effort}{Project Effort in Man months}
\item{Duration}{Duration in months}
\item{Productivity}{Productivity of project calculated by BAK as AKDSI/Effort, so the the larger the value the better the productivity}
}}
\source{
\url{http://madeyski.e-informatyka.pl/reproducible-research/}
}
\usage{
KitchenhamMadeyskiBudgen16.COCOMO
}
\description{
If you use this data set please cite this R package and the following paper when accepted: Barbara Kitchenham, Lech Madeyski, David Budgen, Jacky Keung, Pearl Brereton, Stuart Charters, Shirley Gibbs, and Amnart Pohthong, "Robust Statistical Methods for Empirical Software Engineering", Empirical Software Engineering (in press). DOI: 10.1007/s10664-016-9437-5 (http://dx.doi.org/10.1007/s10664-016-9437-5), URL: http://madeyski.e-informatyka.pl/download/KitchenhamMadeyski16ESE.pdf
}
\details{
Data set collected at TRW by Barry Boehm see: B.W. Boehm. 1981.  Software Engineering Economics. Prentice-Hall.

Explanations by Barbara Kitchehnam / https://terapromise.csc.ncsu.edu:8443/!/#repo/view/head/effort/cocomo/cocomo1/nasa93/nasa93.arff

COCOMO.txt: pro	type	year	Lang	Rely	Data	CPLX	aaf	time	store	virt	turn	type2	acap	aexp	pcap	vexp	lexp	cont	modp	TOOL	TOOLcat	SCED	RVOL	Select	rvolcat	Modecat	Mode1	Mode2	Mode3	KDSI	AKDSI	Effort	Dur	Productivity
}
\examples{
KitchenhamMadeyskiBudgen16.COCOMO

}
\keyword{datasets}

