% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez_post.r
\name{entrez_post}
\alias{entrez_post}
\title{Post IDs to Eutils for later use}
\usage{
entrez_post(db, id = NULL, web_history = NULL, config = NULL, ...)
}
\arguments{
\item{db}{character Name of the database from which the IDs were taken}

\item{id}{vector with unique ID(s) for records in database \code{db}.}

\item{web_history}{A web_history object. Can be used to add to additional
identifiers to an existing web environment on the NCBI}

\item{config}{vector of configuration options passed to httr::GET}

\item{\dots}{character Additional terms to add to the request, see NCBI
documentation linked to in references for a complete list}
}
\description{
Post IDs to Eutils for later use
}
\examples{
\dontrun{  
so_many_snails <- entrez_search(db="nuccore", 
                      "Gastropoda[Organism] AND COI[Gene]", retmax=200)
upload <- entrez_post(db="nuccore", id=so_many_snails$ids)
first <- entrez_fetch(db="nuccore", rettype="fasta", web_history=upload,
                      retmax=10)
second <- entrez_fetch(db="nuccore", file_format="fasta", web_history=upload,
                       retstart=10, retmax=10)
}
}
\references{
\url{http://www.ncbi.nlm.nih.gov/books/NBK25499/#_chapter4_EPost_}
}
\seealso{
\code{\link[httr]{config}} for available httr configurations
}

