% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.haplohh.R
\name{subset.haplohh}
\alias{subset.haplohh}
\title{Subsets object of \code{\link{haplohh-class}}}
\usage{
\method{subset}{haplohh}(
  x,
  select.hap = NULL,
  select.mrk = NULL,
  min_perc_geno.hap = NA,
  min_perc_geno.mrk = 100,
  min_maf = NA,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{object of class \code{\link{haplohh-class}} to be subset.}

\item{select.hap}{expression, indicating haplotypes to select.}

\item{select.mrk}{expression, indicating markers to select.}

\item{min_perc_geno.hap}{threshold on percentage of missing data for haplotypes
(haplotypes with less than \code{min_perc_geno.hap} percent of markers genotyped are discarded). Default is \code{NA},
hence no constraint.}

\item{min_perc_geno.mrk}{threshold on percentage of missing data for markers (markers genotyped on less than
\code{min_perc_geno.mrk} percent of haplotypes are discarded). By default, \code{min_perc_geno.mrk=100},
hence only fully genotyped markers are retained.
This value cannot be set to \code{NA} or zero.}

\item{min_maf}{threshold on the Minor Allele Frequency. Markers having a MAF lower than or equal to minmaf are discarded.
In case of multi-allelic markers the second-most frequent allele is referred to as minor allele.
Setting this value to zero eliminates monomorphic sites. Default is \code{NA},
hence no constraint.}

\item{verbose}{logical. If \code{TRUE} (default), report verbose progress.}

\item{...}{further arguments are ignored.}
}
\description{
Subsets the data of an object of class \code{\link{haplohh-class}},
meeting certain conditions.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#select subset of first 10 hyplotypes and first 5 markers
subset(haplohh_cgu_bta12, select.hap = 1:10, select.mrk = 1:5)
}
\seealso{
\code{\link{haplohh-class}}, \code{\link{data2haplohh}}
}
