% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_model_regp_utils.R
\name{e_coeff_lambda}
\alias{e_coeff_lambda}
\title{Coefficients and lambda}
\usage{
e_coeff_lambda(model, sel.lambda = NULL, label = "Log Lambda")
}
\arguments{
\item{model}{a glmnet model.}

\item{sel.lambda}{the selected lambda.}

\item{label}{a character specifying the title to use on selected lambda tooltip.}
}
\value{
echarts4r plot
}
\description{
Plot the coefficients and selected lambda of a glmnet model.
}
\examples{
x <- model.matrix(Sepal.Length ~ ., iris)[, -1]
y <- iris$Sepal.Length
modelo <- glmnet::cv.glmnet(x, y, standardize = TRUE, alpha = 1, family = "gaussian")
e_coeff_lambda(modelo, log(modelo$lambda[1]))

}
\author{
Joseline Quiros <joseline.quiros@promidat.com>
}
