% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICC.R
\name{ICC.merMod}
\alias{ICC.merMod}
\title{Intra-class correlation.}
\usage{
\method{ICC}{merMod}(model, ...)
}
\arguments{
\item{model}{A fitted model of type 'merMod' (linear, generalized, or
nonlinear).}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
The intra-class correlation of the model.
}
\description{
\code{ICC.merMod} calculates the intra-class correlation (ICC) from a fitted
multi-level model using the 'lme4' package.
}
\details{
The ICC is the proportion of variance that is between-person variance. For
more information, see
\href{http://davidakenny.net/papers/k&h/MLM_R.pdf}{Hoyt & Kenny (2013)}.
}
\examples{
# iris data
if (require(lme4, quietly=TRUE)) {
    model <- lmer(Sepal.Width ~ 1 + (1|Species), data=iris)
    ICC(model)  # .49 of variance is between-subjects
}
}
\seealso{
\code{\link{ICC.lme}}
}

