% Generated by roxygen2 (4.0.2): do not edit by hand
\name{test}
\alias{test}
\title{Test Regular Expression Validity}
\usage{
test(x, quiet, ...)
}
\arguments{
\item{x}{A \code{regexr} object.}

\item{quiet}{logical.  Should \code{test} print warnings about the
concatenated expression and individual chunks?}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of two logical vectors.  The first vector is a test of
the concatenated expression.  The second vector is a logical test of the
validity of each regular expression chunk that makes up the concatenated
expression.
}
\description{
Test regular expression validity of a \code{regexr} object.
}
\examples{
m <- construct(
    space =
        "\\\\s+"
            \%:)\%"I see",

    simp =
        "(?<=(foo))",

    or =
        "(;|:)\\\\s*"
            \%:)\%"comment on what this does",

    "[a]s th[atey]"
)


test(m)
\donttest{
regex(m)[5:7] <- c("(", "([A-Z]|(\\\\d{5})", ")")
test(m)
}
}

