% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_CDScoords.R
\name{refseq_CDScoords}
\alias{refseq_CDScoords}
\title{Extract the coding sequences (CDS) coordinates from a transcript accession}
\usage{
refseq_CDScoords(transcript)
}
\arguments{
\item{transcript}{A character string of the single/multiple transcript id.}
}
\value{
An \code{IRanges} object with the start and end position of the CDS of the
putative mRNAs.
}
\description{
\code{refseq_CDScoords()} Parses a transcript accession (RefSeq format) and extract the CDS coordinates.
The CDS coordinates refer to the mRNA molecule.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
transcript = c("XM_004487701")
refseq_CDScoords(transcript)

\donttest{
transcript = c("XM_004487701", "XM_004488493")
refseq_CDScoords(transcript)}

}
\seealso{
\code{\link{refseq_CDSseq}}
}
\author{
Jose V. Die
}
