% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_AA_length.R
\name{refseq_AA_length}
\alias{refseq_AA_length}
\title{Get the amino acid length from a protein accession}
\usage{
refseq_AA_length(protein, retries)
}
\arguments{
\item{protein}{A character string of the XP id.}

\item{retries}{A numeric value to control the number of retry attempts to handle internet errors.}
}
\value{
A numeric value representing the aa length of the \code{protein}.
}
\description{
\code{refseq_AA_length()} Returns the amino acid length from a single protein accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 # Get the XM ids from a set of XP accessions
 protein = c("XP_004487758", "XP_004488550")
 sapply(protein, function(x) refseq_AA_length(x, retries = 4), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_mRNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
