% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_CDSseq.R
\name{refseq_CDSseq}
\alias{refseq_CDSseq}
\title{Extract the CDS nucleotide sequence into a Biostrings object}
\usage{
refseq_CDSseq(xm)
}
\arguments{
\item{xm}{A character string of the single/multiple XM id.}
}
\value{
An object of \code{DNAStringSet} class.
}
\description{
\code{refseq_CDSseq()} Parses a single/multiple XM acessions (Genbank format) and extract
the CDS nucleotide sequences into a \code{DNAStringSet} object.
}
\examples{
\donttest{
xm <-  c("XM_004487701", "XM_004488493", "XM_004501904")
my_cds <- refseq_CDSseq(xm)
# Now, the `DNAStringSet` can easily used to make a fasta file :
# writeXStringSet(x= my_cds, filepath = "cds_result")}

}
\seealso{
\code{\link{refseq_CDScoords}}
}
\author{
Jose V. Die
}
