\name{reflim}
\alias{reflim}
\title{Reference limits (main function)}
\description{Estimation of reference limits from mixed distributions of normal and pathological laboratory results. Estimates lower and upper reference limits and provides statistical characteristics and graphics to evaluate the results.}
\usage{reflim(x, lognormal = NULL, targets = NULL,
              perc.trunc = 2.5, n.min = 200, apply.rounding = TRUE,
              plot.it = TRUE, plot.all = FALSE, print.n = TRUE,
              main = "reference limits", xlab = "x")}
\arguments{
\item{x}{vector of positive numbers}
\item{lognormal}{Boolean indicating whether a lognormal distribution should be assumed (NULL means that the distribution type is defined automatically)}
\item{targets}{vector of two numbers indicating target reference limits that may have been obtained from external sources}
\item{perc.trunc}{percentage of presumably normal values to be removed from each side}
\item{n.min}{minimum number of observations needed for a robust estimate of reference intervals}
\item{apply.rounding}{Boolean indicating whether the estimated reference limits should be rounded}
\item{plot.it}{Boolean indicating whether graphics should be created}
\item{plot.all}{Boolean indicating whether graphics of all process steps should be created}
\item{print.n}{Boolean indicating whether the number of cases after truncation should be printed on the graph}
\item{main, xlab}{title and x label of the graphic}
}
\value{
\item{$stats}{mean and sd (or meanlog and sdlog) of the truncated vector, number of cases before and after truncation}
\item{$lognormal}{Boolean indicating whether a lognormal distribution has been assumed}
\item{$limits}{estimated reference limits with tolerance intervals}
\item{$targets}{target values with tolerance intervals}
\item{perc.norm}{estimated percentage of non-pathological values}
\item{$confidence.int}{95 percent confidence intervals for the estimated reference limits (depends on n)}
\item{$interpretation}{short text describing the deviation of observed limits from target values}
\item{remarks}{short text describing potential reasons why the reflim function could not be executed}
}
\details{
The reflim function estimates reference limits from the linear part of a normal probability-probability or quantile-quantile plot [1, 2]. It combines several functions to determine the distribution type [3], to truncate the input vector [4], and to generate a truncated quantile-quantile plot [2, 4]. For details concerning the individual functions, which are called by reflim(), you may enter *help(package = reflimR)*.

The default value of perc.trunc is 2.5 meaning that 2.5 percent of the assumed non-pathological values are truncated on both sides of the quantile-quantile plot. By increasing perc.trunc (e.g. to 5 percent), a stronger cut can be applied to reduce the influence of potentially overlapping pathological values.

The argument plot.it is used to compare the observed and the theoretical distribution curves graphically. If target values have been specified, the tolerance intervals of the calculated reference limits will be drawn as colored vertical lines. Green means that the calculated limit is within the tolerance interval of the respective target, yellow means that the calculated limit falls outside but the two tolerance intervals overlap, and red means that there is no overlap between the tolerance intervals.

More detailed graphs of the three underlying steps can be generated by setting plot.all = TRUE. When plot.all is set to TRUE, plot.it is automatically set to TRUE as well.
}
\references{
1. Holmes D, Buhr K. Widespread incorrect implementation of the Hoffmann method, the correct approach, and modern alternatives. Am. J. Clin. Pathol. 2018; 151:328-36. \doi{10.1093/ajcp/aqy149}.

2. Hoffmann G, Lichtinghagen R, Wosniok W. Simple estimation of reference intervals from routine laboratory data. J Lab Med 2015; 39: 389-402. \doi{10.1515/labmed-2015-0104}.

3. Klawonn F, Hoffmann G, Orth M. Quantitative laboratory results: normal or lognormal distribution? J Lab Med 2020; 44: 143-50. \doi{10.1515/labmed-2020-0005}.

4. Klawonn F, Hoffmann G. Using fuzzy cluster analysis to find interesting clusters. In: L.A. Garcia-Escuderoet al. (eds.): Building bridges between soft and statistical methodologies for data science. Springer, Cham (2023), 231-239. \doi{10.1007/978-3-031-15509-3_31}.
}
\examples{
x <- c(rnorm(800, 100, 10), rnorm(100, 70, 15), rnorm(100, 125, 15))
reflim(x, targets = qnorm(c(0.025, 0.975), 100, 10))

x.f <- subset(livertests, livertests$Sex == "f")
reflim(x.f$AST)
reflim(x.f$AST, targets = c(13, 40))
reflim(x.f$AST, targets = targetvalues[3, 3 : 4],
main = "AST/GOT", xlab = targetvalues[3, 2])
reflim(x.f$AST, plot.all = TRUE, main = "AST/GOT", xlab = "U/L")$limits
reflim(x.f$ALB, targets = targetvalues[1, 3 : 4],
  plot.all = TRUE, main = "ALB", xlab = "g/L")$limits
}
