% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_fh}
\alias{comp_fh}
\title{Calculate Fryer Holden Compactness}
\usage{
comp_fh(plans, shp, total_pop, epsg = 3857, ncores = 1)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{total_pop}{A numeric vector with the population for every observation.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{ncores}{TRUE}
}
\value{
numeric vector
}
\description{
Calculate Fryer Holden Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_fh(plans = nh$r_2020, shp = nh, total_pop = pop)

# Or many plans:
comp_fh(plans = nh_m[, 3:5], shp = nh, pop)

}
\references{
Fryer R, Holden R. 2011. Measuring the Compactness of Political Districting Plans.
Journal of Law and Economics.
}
\concept{compactness}
