% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_plans.R
\name{redist.plot.hist}
\alias{redist.plot.hist}
\alias{hist.redist_plans}
\title{Plot a histogram of a summary statistic}
\usage{
redist.plot.hist(plans, qty, bins = NULL, ...)

\method{hist}{redist_plans}(x, qty, ...)
}
\arguments{
\item{plans}{the \code{redist_plans} object.}

\item{qty}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the statistic.}

\item{bins}{the number of bins to use in the histogram. Defaults to Freedman-Diaconis rule.}

\item{...}{passed on to \code{\link[ggplot2]{geom_histogram}}}

\item{x}{\code{\link[dplyr:dplyr_data_masking]{<data-masking>}} the statistic.}
}
\value{
A ggplot
}
\description{
Plots a histogram of a statistic of a \code{\link{redist_plans}} object,
with a reference line for each reference plan, if applicable.
}
\examples{
library(dplyr)
data(iowa)

iowa <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05)
plans <- redist_smc(iowa, nsims = 100, silent = TRUE)
group_by(plans, draw) \%>\%
    summarize(pop_dev = max(abs(total_pop/mean(total_pop) - 1))) \%>\%
    redist.plot.hist(pop_dev)

}
\concept{plot}
