% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist.R
\name{redist.mcmc.anneal}
\alias{redist.mcmc.anneal}
\title{MCMC Redistricting Simulator using Simulated Annealing}
\usage{
redist.mcmc.anneal(adjobj, popvec, ndists,
initcds, num_hot_steps, num_annealing_steps,
num_cold_steps,
eprob, lambda, popcons, grouppopvec,
areasvec, countymembership, borderlength_mat,
ssdmat, constraint, constraintweights,
compactness_metric, rngseed, maxiterrsg,
adapt_lambda, adapt_eprob,
contiguitymap, exact_mh,
savename, verbose, ncores)
}
\arguments{
\item{adjobj}{An adjacency matrix, list, or object of class
"SpatialPolygonsDataFrame."}

\item{popvec}{A vector containing the populations of each geographic
unit}

\item{ndists}{The numbe of congressional districts. The default is
\code{NULL}.}

\item{initcds}{A vector containing the congressional district labels
of each geographic unit. The default is \code{NULL}. If not provided,
random and contiguous congressional district assignments will be generated
using \code{redist.rsg}.}

\item{num_hot_steps}{The number of steps to run the simulator at beta = 0.
Default is 40000.}

\item{num_annealing_steps}{The number of steps to run the simulator with
linearly changing beta schedule. Default is 60000}

\item{num_cold_steps}{The number of steps to run the simulator at beta = 1.
Default is 20000.}

\item{eprob}{The probability of keeping an edge connected. The
default is \code{0.05}.}

\item{lambda}{The parameter detmerining the number of swaps to attempt
each iteration fo the algoirhtm. The number of swaps each iteration is
equal to Pois(\code{lambda}) + 1. The default is \code{0}.}

\item{popcons}{The strength of the hard population
constraint. \code{popcons} = 0.05 means that any proposed swap that
brings a district more than 5\% away from population parity will be
rejected. The default is \code{NULL}.}

\item{grouppopvec}{A vector of populations for some sub-group of
interest. The default is \code{NULL}.}

\item{areasvec}{A vector of precinct areas for discrete Polsby-Popper.
The default is \code{NULL}.}

\item{countymembership}{A vector of county membership assignments. The default is \code{NULL}.}

\item{borderlength_mat}{A matrix of border length distances, where
the first two columns are the indices of precincts sharing a border and
the third column is its distance. Default is \code{NULL}.}

\item{ssdmat}{A matrix of squared distances between geographic
units. The default is \code{NULL}.}

\item{constraint}{Which constraint to apply. Accepts any combination of \code{compact},
\code{segregation}, \code{population}, \code{similarity}, or \code{none}
(no constraint applied). The default is NULL.}

\item{constraintweights}{The weights to apply to each constraint. Should be a vector
the same length as constraint. Default is NULL.}

\item{compactness_metric}{The compactness metric to use when constraining on
compactness. Default is \code{fryer-holden}, the other implemented option
is \code{polsby-popper}.}

\item{rngseed}{Allows the user to set the seed for the
simulations. Default is \code{NULL}.}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{contiguitymap}{Use queens or rooks distance criteria for generating an
adjacency list from a "SpatialPolygonsDataFrame" data type.
Default is "rooks".}

\item{exact_mh}{Whether to use the approximate (0) or exact (1)
Metropolis-Hastings ratio calculation for accept-reject rule. Default is FALSE.}

\item{savename}{Filename to save simulations. Default is \code{NULL}.}

\item{verbose}{Whether to print initialization statement.
Default is \code{TRUE}.}

\item{ncores}{The number of cores available to parallelize over. Default is 1.}
}
\description{
\code{redist.mcmc.anneal} simulates congressional redistricting plans
using Markov chain Monte Carlo methods coupled with simulated annealing.
}
