# See http://www.unicode.org/charts
# European Scripts
#' @rdname Unicode
#' @export
ARMENIAN <- regex("\u0530-\u058F")

#' @rdname Unicode
#' @export
ARMENIAN_LIGATURES <- regex("\uFB00-\uFB4F")

#' @rdname Unicode
#' @export
CAUCASIAN_ALBANIAN <- regex("\U10530-\U1056F")

#' @rdname Unicode
#' @export
CYPRIOT_SYLLABARY <- regex("\U10800-\U1083F")

#' @rdname Unicode
#' @export
CYRILLIC <- regex("\u0400-\u04FF")

#' @rdname Unicode
#' @export
CYRILLIC_SUPPLEMENT <- regex("\u0500-\u052F")

#' @rdname Unicode
#' @export
CYRILLIC_EXTENDED_A <- regex("\u2DE0-\u2DFF")

#' @rdname Unicode
#' @export
CYRILLIC_EXTENDED_B <- regex("\uA640-\uA69F")

#' @rdname Unicode
#' @export
ELBASAN <- regex("\U10500-\U1052F")

#' @rdname Unicode
#' @export
GEORGIAN <- regex("\u10A0-\u10FF")

#' @rdname Unicode
#' @export
GEORGIAN_SUPPLEMENT <- regex("\u2D00-\u2D2F")

#' @rdname Unicode
#' @export
GLAGOLITIC <- regex("\u2C00-\u2C5F")

#' @rdname Unicode
#' @export
GOTHIC <- regex("\U10330-\U1034F")

#' @rdname Unicode
#' @export
GREEK_AND_COPTIC <- regex("\u0370-\u03FF")

#' @rdname Unicode
#' @export
GREEK_EXTENDED <- regex("\u1F00-\u1FFF")

#' @rdname Unicode
#' @export
LATIN <- regex("\u0020-\u007F") #This includes punctuation and space, not control chars.

#' @rdname Unicode
#' @export
LATIN_1_SUPPLEMENT <- regex("\u0080-\u00FF")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_A <- regex("\u0100-\u017F")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_B <- regex("\u0180-\u024F")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_C <- regex("\u2C60-\u2C7F")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_D <- regex("\uA720-\uA7FF")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_E <- regex("\uAB30-\uAB6F")

#' @rdname Unicode
#' @export
LATIN_EXTENDED_ADDITIONAL <- regex("\u1E00-\u1EFF")

#' @rdname Unicode
#' @export
LATIN_LIGATURES <- regex("\uFB00-\uFB4F")

#' @rdname Unicode
#' @export
LINEAR_A <- regex("\U10600-\U1077F")

#' @rdname Unicode
#' @export
LINEAR_B_SYLLABARY <- regex("\U10000-\U1007F")

#' @rdname Unicode
#' @export
LINEAR_B_IDEOGRAMS <- regex("\U10080-\U100FF")

#' @rdname Unicode
#' @export
OGHAM <- regex("\u1680-\u169F")

#' @rdname Unicode
#' @export
OLD_ITALIC <- regex("\U10300-\U1032F")

#' @rdname Unicode
#' @export
OLD_PERMIC <- regex("\U10350-\U1037F")

#' @rdname Unicode
#' @export
PHAISTOS_DISC <- regex("\U101D0-\U101FF")

#' @rdname Unicode
#' @export
RUNIC <- regex("\u16A0-\u16FF")

#' @rdname Unicode
#' @export
SHAVIAN <- regex("\U10450-\U1047F")


# Phonetic & Shorthand Symbols
#' @rdname Unicode
#' @export
DUPLOYAN <- regex("\U1BC00-\U1BC9F")

#' @rdname Unicode
#' @export
SHORTHAND_FORMAT_CONTROLS <- regex("\U1BCA0-\U1BCAF")

#' @rdname Unicode
#' @export
IPA_EXTENSIONS <- regex("\u0250-\u02AF")

#' @rdname Unicode
#' @export
PHONETIC_EXTENSIONS <- regex("\u1D00-\u1D7F")

#' @rdname Unicode
#' @export
PHONETIC_EXTENSIONS_SUPPLEMENT <- regex("\u1D80-\u1DBF")

#' @rdname Unicode
#' @export
MODIFIER_TONE_LETTERS <- regex("\uA700-\uA71F")

#' @rdname Unicode
#' @export
SPACING_MODIFIER_LETTERS <- regex("\u02B0-\u02FF")

#' @rdname Unicode
#' @export
SUPERSCRIPTS_AND_SUBSCRIPTS <- regex("\u2070-\u209F")


# Combining Diacritics
#' @rdname Unicode
#' @export
COMBINING_DIACRITIC_MARKS <- regex("\u0300-\u036F")

#' @rdname Unicode
#' @export
COMBINING_DIACRITIC_SUPPLEMENT <- regex("\u1DC0-\u1DFF")

#' @rdname Unicode
#' @export
COMBINING_DIACRITIC_EXTENDED <- regex("\u1AB0-\u1AFF")

#' @rdname Unicode
#' @export
COMBINING_HALF_MARKS <- regex("\uFE20-\uFE2F")


#African Scripts
#' @rdname Unicode
#' @export
BAMUN <- regex("\uA6A0-\uA6FF")

#' @rdname Unicode
#' @export
BAMUN_SUPPLEMENT <- regex("\U16800-\U16A3F")

#' @rdname Unicode
#' @export
BASSA_VAH <- regex("\U16AD0-\U16AFF")

#' @rdname Unicode
#' @export
COPTIC <- regex("\u2C80-\u2CFF")

#' @rdname Unicode
#' @export
COPTIC_EPACT_NUMBERS <- regex("\U102E0-\U102FF")

#' @rdname Unicode
#' @export
EGYPTIAN_HIEROGLYPHS <- regex("\U13000-\U1342F")

#' @rdname Unicode
#' @export
ETHIOPIC <- regex("\u1200-\u137F")

#' @rdname Unicode
#' @export
ETHIOPIC_SUPPLEMENT <- regex("\u1380-\u139F")

#' @rdname Unicode
#' @export
ETHIOPIC_EXTENDED <- regex("\u2D80-\u2DDF")

#' @rdname Unicode
#' @export
ETHIOPIC_EXTENDED_A <- regex("\uAB00-\uAB2F")

#' @rdname Unicode
#' @export
MENDE_KIKAKUI <- regex("\U1E800-\U1E8DF")

#' @rdname Unicode
#' @export
MEROITIC_CURSIVE <- regex("\U109A0-\U109FF")

#' @rdname Unicode
#' @export
MEROITIC_HIEROGLYPHS <- regex("\U10980-\U1099F")

#' @rdname Unicode
#' @export
NKO <- regex("\u07C0-\u07FF")

#' @rdname Unicode
#' @export
OSMANYA <- regex("\U10480-\U104AF")

#' @rdname Unicode
#' @export
TIFINAGH <- regex("\u2D30-\u2D7F")

#' @rdname Unicode
#' @export
VAI <- regex("\uA500-\uA63F")


# Middle Eastern Scripts
#' @rdname Unicode
#' @export
ARABIC <- regex("\u0600-\u06FF")

#' @rdname Unicode
#' @export
ARABIC_SUPPLEMENT <- regex("\u0750-\u077F")

#' @rdname Unicode
#' @export
ARABIC_EXTENDED_A <- regex("\u08A0-\u08FF")

#' @rdname Unicode
#' @export
ARABIC_PRESENTATION_FORMS_A <- regex("\uFB50-\uFDFF")

#' @rdname Unicode
#' @export
ARABIC_PRESENTATION_FORMS_B <- regex("\uFE70-\uFEFF")

#' @rdname Unicode
#' @export
IMPERIAL_ARAMAIC <- regex("\U10840-\U1085F")

#' @rdname Unicode
#' @export
AVESTAN <- regex("\U10B00-\U10B3F")

#' @rdname Unicode
#' @export
CARIAN <- regex("\U102A0-\U102DF")

#' @rdname Unicode
#' @export
CUNEIFORM <- regex("\U12000-\U123FF")

#' @rdname Unicode
#' @export
CUNEIFORM_NUMBERS_AND_PUNCTUATION <- regex("\U12400-\U1247F")

#' @rdname Unicode
#' @export
OLD_PERSIAN <- regex("\U103A0-\U103DF")

#' @rdname Unicode
#' @export
UGARITIC <- regex("\U10380-\U1039F")

#' @rdname Unicode
#' @export
HEBREW <- regex("\u0590-\u05FF")

#' @rdname Unicode
#' @export
LYCIAN <- regex("\U10280-\U1029F")

#' @rdname Unicode
#' @export
LYDIAN <- regex("\U10920-\U1093F")

#' @rdname Unicode
#' @export
MANDAIC <- regex("\u0840-\u085F")

#' @rdname Unicode
#' @export
NABATAEAN <- regex("\U10880-\U108AF")

#' @rdname Unicode
#' @export
OLD_NORTH_ARABIAN <- regex("\U10A80-\U10A9F")

#' @rdname Unicode
#' @export
OLD_SOUTH_ARABIAN <- regex("\U10A60-\U10A7F")

#' @rdname Unicode
#' @export
PAHLAVI_INSCRIPTIONAL <- regex("\U10B60-\U10B7F")

#' @rdname Unicode
#' @export
PAHLAVI_PSALTER <- regex("\U10B80-\U10BAF")

#' @rdname Unicode
#' @export
PALMYRENE <- regex("\U10860-\U1087F")

#' @rdname Unicode
#' @export
PHOENICIAN <- regex("\U10900-\U1091F")

#' @rdname Unicode
#' @export
SAMARITAN <- regex("\u0800-\u083F")

#' @rdname Unicode
#' @export
SYRIAC <- regex("\u0700-\u074F")


# Central Asian Scripts
#' @rdname Unicode
#' @export
MANICHAEAN <- regex("\U10AC0-\U10AFF")

#' @rdname Unicode
#' @export
MONGOLIAN <- regex("\u1800-\u18AF")

#' @rdname Unicode
#' @export
OLD_TURKIC <- regex("\U10C00-\U10C4F")

#' @rdname Unicode
#' @export
PHAGS_PA <- regex("\uA840-\uA87F")

#' @rdname Unicode
#' @export
TIBETAN <- regex("\u0F00-\u0FFF")


# South Asian Scripts
#' @rdname Unicode
#' @export
BENGALI_AND_ASSAMESE <- regex("\u0980-\u09FF")

#' @rdname Unicode
#' @export
BRAHMI <- regex("\U11000-\U1107F")

#' @rdname Unicode
#' @export
CHAKMA <- regex("\U11100-\U1114F")

#' @rdname Unicode
#' @export
DEVANAGARI <- regex("\u0900-\u097F")

#' @rdname Unicode
#' @export
DEVANAGARI_EXTENDED <- regex("\uA8E0-\uA8FF")

#' @rdname Unicode
#' @export
GRANTHA <- regex("\U11300-\U1137F")

#' @rdname Unicode
#' @export
GUJARATI <- regex("\u0A80-\u0AFF")

#' @rdname Unicode
#' @export
GURMUKHI <- regex("\u0A00-\u0A7F")

#' @rdname Unicode
#' @export
KAITHI <- regex("\U11080-\U110CF")

#' @rdname Unicode
#' @export
KANNADA <- regex("\u0C80-\u0CFF")

#' @rdname Unicode
#' @export
KHAROSHTHI <- regex("\U10A00-\U10A5F")

#' @rdname Unicode
#' @export
KHOJKI <- regex("\U11200-\U1124F")

#' @rdname Unicode
#' @export
KHUDAWADI <- regex("\U112B0-\U112FF")

#' @rdname Unicode
#' @export
LEPCHA <- regex("\u1C00-\u1C4F")

#' @rdname Unicode
#' @export
LIMBU <- regex("\u1900-\u194F")

#' @rdname Unicode
#' @export
MAHAJANI <- regex("\U11150-\U1117F")

#' @rdname Unicode
#' @export
MALAYALAM <- regex("\u0D00-\u0D7F")

#' @rdname Unicode
#' @export
MEETEI_MAYEK <- regex("\uABC0-\uABFF")

#' @rdname Unicode
#' @export
MEETEI_MAYEK_EXTENSIONS <- regex("\uAAE0-\uAAFF")

#' @rdname Unicode
#' @export
MODI <- regex("\U11600-\U1165F")

#' @rdname Unicode
#' @export
MRO <- regex("\U16A40-\U16A6F")

#' @rdname Unicode
#' @export
OL_CHIKI <- regex("\u1C50-\u1C7F")

#' @rdname Unicode
#' @export
ORIYA <- regex("\u0B00-\u0B7F")

#' @rdname Unicode
#' @export
SAURASHTRA <- regex("\uA880-\uA8DF")

#' @rdname Unicode
#' @export
SHARADA <- regex("\U11180-\U111DF")

#' @rdname Unicode
#' @export
SIDDHAM <- regex("\U11580-\U115FF")

#' @rdname Unicode
#' @export
SINHALA <- regex("\u0D80-\u0DFF")

#' @rdname Unicode
#' @export
SINHALA_ARCHAIC_NUMBERS <- regex("\U111E0-\U111FF")

#' @rdname Unicode
#' @export
SORA_SOMPENG <- regex("\U110D0-\U110FF")

#' @rdname Unicode
#' @export
SYLOTI_NAGRI <- regex("\uA800-\uA82F")

#' @rdname Unicode
#' @export
TAKRI <- regex("\U11680-\U116CF")

#' @rdname Unicode
#' @export
TAMIL <- regex("\u0B80-\u0BFF")

#' @rdname Unicode
#' @export
TELUGU <- regex("\u0C00-\u0C7F")

#' @rdname Unicode
#' @export
THAANA <- regex("\u0780-\u07BF")

#' @rdname Unicode
#' @export
TIRHUTA <- regex("\U11480-\U114DF")

#' @rdname Unicode
#' @export
VEDIC_EXTENSIONS <- regex("\u1CD0-\u1CFF")

#' @rdname Unicode
#' @export
WARANG_CITI <- regex("\U118A0-\U118FF")


# Southeast Asian Scripts
#' @rdname Unicode
#' @export
CHAM <- regex("\uAA00-\uAA5F")

#' @rdname Unicode
#' @export
KAYAH_LI <- regex("\uA900-\uA92F")

#' @rdname Unicode
#' @export
KHMER <- regex("\u1780-\u17FF")

#' @rdname Unicode
#' @export
KHMER_SYMBOLS <- regex("\u19E0-\u19FF")

#' @rdname Unicode
#' @export
LAO <- regex("\u0E80-\u0EFF")

#' @rdname Unicode
#' @export
MYANMAR <- regex("\u1000-\u109F")

#' @rdname Unicode
#' @export
MYANMAR_EXTENDED_A <- regex("\uAA60-\uAA7F")

#' @rdname Unicode
#' @export
MYANMAR_EXTENDED_B <- regex("\uA9E0-\uA9FF")

#' @rdname Unicode
#' @export
NEW_TAI_LUE <- regex("\u1980-\u19DF")

#' @rdname Unicode
#' @export
PAHAWH_HMONG <- regex("\U16B00-\U16B8F")

#' @rdname Unicode
#' @export
PAU_CIN_HAU <- regex("\U11AC0-\U11AFF")

#' @rdname Unicode
#' @export
TAI_LE <- regex("\u1950-\u197F")

#' @rdname Unicode
#' @export
TAI_THAM <- regex("\u1A20-\u1AAF")

#' @rdname Unicode
#' @export
TAI_VIET <- regex("\uAA80-\uAADF")

#' @rdname Unicode
#' @export
THAI <- regex("\u0E00-\u0E7F")


# Indonesia & Oceania Scripts
#' @rdname Unicode
#' @export
BALINESE <- regex("\u1B00-\u1B7F")

#' @rdname Unicode
#' @export
BATAK <- regex("\u1BC0-\u1BFF")

#' @rdname Unicode
#' @export
BUGINESE <- regex("\u1A00-\u1A1F")

#' @rdname Unicode
#' @export
BUHID <- regex("\u1740-\u175F")

#' @rdname Unicode
#' @export
HANUNOO <- regex("\u1720-\u173F")

#' @rdname Unicode
#' @export
JAVANESE <- regex("\uA980-\uA9DF")

#' @rdname Unicode
#' @export
REJANG <- regex("\uA930-\uA95F")

#' @rdname Unicode
#' @export
SUNDANESE <- regex("\u1B80-\u1BBF")

#' @rdname Unicode
#' @export
SUNDANESE_SUPPLEMENT <- regex("\u1CC0-\u1CCF")

#' @rdname Unicode
#' @export
TAGALOG <- regex("\u1700-\u171F")

#' @rdname Unicode
#' @export
TAGBANWA <- regex("\u1760-\u177F")


# East Asian Scripts
#' @rdname Unicode
#' @export
BOPOMOFO <- regex("\u3100-\u312F")

#' @rdname Unicode
#' @export
BOPOMOFO_EXTENDED <- regex("\u31A0-\u31BF")

#' @rdname Unicode
#' @export
CJK_UNIFIED_IDEOGRAPHS <- regex("\u4E00-\u9FCC")

#' @rdname Unicode
#' @export
CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A <- regex("\u3400-\u4DB5")

#' @rdname Unicode
#' @export
CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B <- regex("\U20000-\U2A6D6")

#' @rdname Unicode
#' @export
CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C <- regex("\U2A700-\U2B734")

#' @rdname Unicode
#' @export
CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D <- regex("\U2B740-\U2B81D")

#' @rdname Unicode
#' @export
CJK_COMPATIBILITY_IDEOGRAPHS <- regex("\uF900-\uFAFF")

#' @rdname Unicode
#' @export
CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT <- regex("\U2F800-\U2FA1F")

#' @rdname Unicode
#' @export
KANGXI_RADICALS <- regex("\u2F00-\u2FDF")

#' @rdname Unicode
#' @export
KANGXI_RADICALS_SUPPLEMENT <- regex("\u2E80-\u2EFF")

#' @rdname Unicode
#' @export
CJK_STROKES <- regex("\u31C0-\u31EF")

#' @rdname Unicode
#' @export
CJK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS <- regex("\u2FF0-\u2FFF")

#' @rdname Unicode
#' @export
HANGUL_JAMO <- regex("\u1100-\u11FF")

#' @rdname Unicode
#' @export
HANGUL_JAMO_EXTENDED_A <- regex("\uA960-\uA97F")

#' @rdname Unicode
#' @export
HANGUL_JAMO_EXTENDED_B <- regex("\uD7B0-\uD7FF")

#' @rdname Unicode
#' @export
HANGUL_COMPATIBILITY_JAMO <- regex("\u3130-\u318F")

#' @rdname Unicode
#' @export
HANGUL_SYLLABLES <- regex("\uAC00-\uD7AF")

#' @rdname Unicode
#' @export
HIRAGANA <- regex("\u3040-\u309F")

#' @rdname Unicode
#' @export
KATAKANA <- regex("\u30A0-\u30FF")

#' @rdname Unicode
#' @export
KATAKANA_PHONETIC_EXTENSIONS <- regex("\u31F0-\u31FF")

#' @rdname Unicode
#' @export
KANA_SUPPLEMENT <- regex("\U1B000-\U1B0FF")

#' @rdname Unicode
#' @export
KANBUN <- regex("\u3190-\u319F")

#' @rdname Unicode
#' @export
LISU <- regex("\uA4D0-\uA4FF")

#' @rdname Unicode
#' @export
MIAO <- regex("\U16F00-\U16F9F")

#' @rdname Unicode
#' @export
YI_SYLLABLES <- regex("\uA000-\uA48F")

#' @rdname Unicode
#' @export
YI_RADICALS <- regex("\uA490-\uA4CF")


# American Scripts
#' @rdname Unicode
#' @export
CHEROKEE <- regex("\u13A0-\u13FF")

#' @rdname Unicode
#' @export
DESERET <- regex("\U10400-\U1044F")

#' @rdname Unicode
#' @export
UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS <- regex("\u1400-\u167F")

#' @rdname Unicode
#' @export
UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED <- regex("\u18B0-\u18FF")


# Other
#' @rdname Unicode
#' @export
ALPHABETIC_PRESENTATION_FORMS <- regex("\uFB00-\uFB4F")

#' @rdname Unicode
#' @export
HALFWIDTH_AND_FULLWIDTH_FORMS <- regex("\uFF00-\uFFEF")


# Punctuation
#' @rdname Unicode
#' @export
GENERAL_PUNCTUATION <- regex("\u2000-\u206F")

#' @rdname Unicode
#' @export
LATIN_1_PUNCTUATION <- regex("\u00A1-00BF")

#' @rdname Unicode
#' @export
SMALL_FORM_VARIANTS <- regex("\uFE50-\uFE6F")

#' @rdname Unicode
#' @export
SUPPLEMENTAL_PUNCTUATION <- regex("\u2E00-\u2E7F")

#' @rdname Unicode
#' @export
CJK_SYMBOLS_AND_PUNCTUATION <- regex("\u3000-\u303F")

#' @rdname Unicode
#' @export
CJK_COMPATIBILITY_FORMS <- regex("\uFE30-\uFE4F")

#' @rdname Unicode
#' @export
FULLWIDTH_ASCII_PUNCTUATION <- regex("\uFF01-\uFF60")

#' @rdname Unicode
#' @export
VERTICAL_FORMS <- regex("\uFE10-\uFE1F")


# Alphanumeric Symbols
#' @rdname Unicode
#' @export
LETTERLIKE_SYMBOLS <- regex("\u2100-\u214F")

#' @rdname Unicode
#' @export
ANCIENT_SYMBOLS <- regex("\U10190-\U101CF")

#' @rdname Unicode
#' @export
MATHEMATICAL_ALPHANUMERIC_SYMBOLS <- regex("\U1D400-\U1D7FF")

#' @rdname Unicode
#' @export
ARABIC_MATHEMATICAL_ALPHANUMERIC_SYMBOLS <- regex("\U1EE00-\U1EEFF")

#' @rdname Unicode
#' @export
ENCLOSED_ALPHANUMERICS <- regex("\u2460-\u24FF")

#' @rdname Unicode
#' @export
ENCLOSED_ALPHANUMERIC_SUPPLEMENT <- regex("\U1F100-\U1F1FF")

#' @rdname Unicode
#' @export
ENCLOSED_CJK_LETTERS_AND_MONTHS <- regex("\u3200-\u32FF")

#' @rdname Unicode
#' @export
ENCLOSED_IDEOGRAPHIC_SUPPLEMENT <- regex("\U1F200-\U1F2FF")

#' @rdname Unicode
#' @export
CJK_COMPATIBILITY <- regex("\u3300-\u33FF")


# Technical Symbols
#' @rdname Unicode
#' @export
MISCELLANEOUS_TECHNICAL <- regex("\u2300-\u23FF")

#' @rdname Unicode
#' @export
CONTROL_PICTURES <- regex("\u2400-\u243F")

#' @rdname Unicode
#' @export
OPTICAL_CHARACTER_RECOGNITION <- regex("\u2440-\u245F")


# Combining Diacritics
#' @rdname Unicode
#' @export
COMBINING_DIACRITIC_MARKS_FOR_SYMBOLS <- regex("\u20D0-\u20FF")


# Numbers and Digits
#' @rdname Unicode
#' @export
AEGEAN_NUMBERS <- regex("\U10100-\U1013F")

#' @rdname Unicode
#' @export
ANCIENT_GREEK_NUMBERS <- regex("\U10140-\U1018F")

#' @rdname Unicode
#' @export
FULLWIDTH_ASCII_DIGITS <- regex("\uFF10-\uFF19")

#' @rdname Unicode
#' @export
COMMON_INDIC_NUMBER_FORMS <- regex("\uA830-\uA83F")

#' @rdname Unicode
#' @export
COPTIC_EPACT_NUMBERS <- regex("\U102E0-\U102FF")

#' @rdname Unicode
#' @export
COUNTING_ROD_NUMERALS <- regex("\U1D360-\U1D37F")

#' @rdname Unicode
#' @export
NUMBER_FORMS <- regex("\u2150-\u218F")

#' @rdname Unicode
#' @export
RUMI_NUMERAL_SYMBOLS <- regex("\U10E60-\U10E7F")

#' @rdname Unicode
#' @export
SINHALA_ARCHAIC_NUMBERS <- regex("\U111E0-\U111FF")


# Mathematical Symbols
#' @rdname Unicode
#' @export
MATH_ARROWS <- regex("\u2190-\u21FF")

#' @rdname Unicode
#' @export
SUPPLEMENTAL_ARROWS_A <- regex("\u27F0-\u27FF")

#' @rdname Unicode
#' @export
SUPPLEMENTAL_ARROWS_A <- regex("\u2900-\u297F")

#' @rdname Unicode
#' @export
SUPPLEMENTAL_ARROWS_A <- regex("\U1F800-\U1F8FF")

#' @rdname Unicode
#' @export
ADDITIONAL_ARROWS <- regex("\u2B00-\u2BFF")


# Mathematical Operators
#' @rdname Unicode
#' @export
SUPPLEMENTAL_MATHEMATICAL_OPERATORS <- regex("\u2A00-\u2AFF")

#' @rdname Unicode
#' @export
MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A <- regex("\u27C0-\u27EF")

#' @rdname Unicode
#' @export
MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B <- regex("\u2980-\u29FF")

#' @rdname Unicode
#' @export
FLOORS_AND_CEILINGS <- regex("\u2308-\u230B")

#' @rdname Unicode
#' @export
INVISIBLE_OPERATORS <- regex("\u2061-\u2064")

#' @rdname Unicode
#' @export
GEOMETRIC_SHAPES <- regex("\u25A0-\u25FF")

#' @rdname Unicode
#' @export
BOX_DRAWING <- regex("\u2500-\u257F")

#' @rdname Unicode
#' @export
BLOCK_ELEMENTS <- regex("\u2580-\u259F")

#' @rdname Unicode
#' @export
GEOMETRIC_SHAPES_EXTENDED <- regex("\U1F780-\U1F7FF")


# Other Symbols
#' @rdname Unicode
#' @export
ALCHEMICAL_SYMBOLS <- regex("\U1F700-\U1F77F")

#' @rdname Unicode
#' @export
BRAILLE_PATTERNS <- regex("\u2800-\u28FF")

#' @rdname Unicode
#' @export
CURRENCY_SYMBOLS <- regex("\u20A0-\u20CF")


# Dingbats
#' @rdname Unicode
#' @export
DINGBATS <- regex("\u2700-\u27BF")

#' @rdname Unicode
#' @export
ORNAMENTAL_DINGBATS <- regex("\U1F650-\u1F67")


# Emoticons
#' @rdname Unicode
#' @export
EMOTICONS <- regex("\U1F600-\U1F64F")


# Game Symbols
#' @rdname Unicode
#' @export
CHESS_CHECKERS_DRAUGHTS <- regex("\u2654-\u265F\u26C0-\u26C3")

#' @rdname Unicode
#' @export
DOMINO_TILES <- regex("\U1F030-\U1F09F")

#' @rdname Unicode
#' @export
JAPANESE_CHESS <- regex("\u2616-\u2617")

#' @rdname Unicode
#' @export
MAHJONG_TILES <- regex("\U1F000-\U1F02F")

#' @rdname Unicode
#' @export
PLAYING_CARDS <- regex("\U1F0A0-\U1F0FF")

#' @rdname Unicode
#' @export
CARD_SUITS <- regex("\u2660-\u2667")


# Miscellanous Symbols
#' @rdname Unicode
#' @export
MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS <- regex("\U1F300-\U1F5FF")


# Musical Symbols
#' @rdname Unicode
#' @export
MUSICAL_SYMBOLS <- regex("\U1D100-\U1D1FF")

#' @rdname Unicode
#' @export
ANCIENT_GREEK_MUSICAL_NOTATION <- regex("\U1D200-\U1D24F")

#' @rdname Unicode
#' @export
BYZANTINE_MUSICAL_SYMBOLS <- regex("\U1D000-\U1D0FF")


# Transport and Map Symbols
#' @rdname Unicode
#' @export
TRANSPORT_AND_MAP_SYMBOLS <- regex("\U1F680-\U1F6FF")


# Yijing Symbols
#' @rdname Unicode
#' @export
YIJING_MONO_DI_AND_TRIGRAMS <- regex("\u268A-\u268F\u2630-\u2637")

#' @rdname Unicode
#' @export
YIJING_HEXAGRAM_SYMBOLS <- regex("\u4DC0-\u4DFF")

#' @rdname Unicode
#' @export
TAI_XUAN_JING_SYMBOLS <- regex("\U1D300-\U1D35F")


# Specials
#' @rdname Unicode
#' @export
SPECIALS <- regex("\uFFF0-\uFFFD")  #roxygen chokes on the non-characters \uFFFE and \uFFFF


# Tags
#' @rdname Unicode
#' @export
TAGS <- regex("\UE0000-\UE007F")


# Variation Selectors
#' @rdname Unicode
#' @export
VARIATION_SELECTORS <- regex("\uFE00-\uFE0F")

#' @rdname Unicode
#' @export
VARIATION_SELECTORS_SUPPLEMENT <- regex("\UE0100-\UE01EF")


# Private Use
#' @rdname Unicode
#' @export
PRIVATE_USE_AREA <- regex("\uE000-\uF8FF")

#' @rdname Unicode
#' @export
SUPPLEMENTARY_PRIVATE_USE_AREA_A <- regex("\UF0000-\UFFFFF")

#' @rdname Unicode
#' @export
SUPPLEMENTARY_PRIVATE_USE_AREA_B <- regex("\U100000-\U10FFFD")
